package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AssociatePersonasToEntitiesResponse(
    failedEntityList: Option[Iterable[zio.aws.kendra.model.FailedEntity]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse = {
    import AssociatePersonasToEntitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse
      .builder()
      .optionallyWith(
        failedEntityList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedEntityList)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly =
    zio.aws.kendra.model.AssociatePersonasToEntitiesResponse
      .wrap(buildAwsValue())
}
object AssociatePersonasToEntitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AssociatePersonasToEntitiesResponse =
      zio.aws.kendra.model.AssociatePersonasToEntitiesResponse(
        failedEntityList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedEntityList
        : Option[List[zio.aws.kendra.model.FailedEntity.ReadOnly]]
    def getFailedEntityList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.FailedEntity.ReadOnly]] =
      AwsError.unwrapOptionField("failedEntityList", failedEntityList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse
  ) extends zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly {
    override val failedEntityList
        : Option[List[zio.aws.kendra.model.FailedEntity.ReadOnly]] = scala
      .Option(impl.failedEntityList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.FailedEntity.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AssociatePersonasToEntitiesResponse
  ): zio.aws.kendra.model.AssociatePersonasToEntitiesResponse.ReadOnly =
    new Wrapper(impl)
}
