package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttributeFilter(
    andAllFilters: Option[Iterable[zio.aws.kendra.model.AttributeFilter]] =
      None,
    orAllFilters: Option[Iterable[zio.aws.kendra.model.AttributeFilter]] = None,
    notFilter: Option[zio.aws.kendra.model.AttributeFilter] = None,
    equalsTo: Option[zio.aws.kendra.model.DocumentAttribute] = None,
    containsAll: Option[zio.aws.kendra.model.DocumentAttribute] = None,
    containsAny: Option[zio.aws.kendra.model.DocumentAttribute] = None,
    greaterThan: Option[zio.aws.kendra.model.DocumentAttribute] = None,
    greaterThanOrEquals: Option[zio.aws.kendra.model.DocumentAttribute] = None,
    lessThan: Option[zio.aws.kendra.model.DocumentAttribute] = None,
    lessThanOrEquals: Option[zio.aws.kendra.model.DocumentAttribute] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AttributeFilter = {
    import AttributeFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AttributeFilter
      .builder()
      .optionallyWith(
        andAllFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.andAllFilters)
      .optionallyWith(
        orAllFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.orAllFilters)
      .optionallyWith(notFilter.map(value => value.buildAwsValue()))(
        _.notFilter
      )
      .optionallyWith(equalsTo.map(value => value.buildAwsValue()))(_.equalsTo)
      .optionallyWith(containsAll.map(value => value.buildAwsValue()))(
        _.containsAll
      )
      .optionallyWith(containsAny.map(value => value.buildAwsValue()))(
        _.containsAny
      )
      .optionallyWith(greaterThan.map(value => value.buildAwsValue()))(
        _.greaterThan
      )
      .optionallyWith(greaterThanOrEquals.map(value => value.buildAwsValue()))(
        _.greaterThanOrEquals
      )
      .optionallyWith(lessThan.map(value => value.buildAwsValue()))(_.lessThan)
      .optionallyWith(lessThanOrEquals.map(value => value.buildAwsValue()))(
        _.lessThanOrEquals
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AttributeFilter.ReadOnly =
    zio.aws.kendra.model.AttributeFilter.wrap(buildAwsValue())
}
object AttributeFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AttributeFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AttributeFilter =
      zio.aws.kendra.model.AttributeFilter(
        andAllFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        orAllFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        notFilter.map(value => value.asEditable),
        equalsTo.map(value => value.asEditable),
        containsAll.map(value => value.asEditable),
        containsAny.map(value => value.asEditable),
        greaterThan.map(value => value.asEditable),
        greaterThanOrEquals.map(value => value.asEditable),
        lessThan.map(value => value.asEditable),
        lessThanOrEquals.map(value => value.asEditable)
      )
    def andAllFilters
        : Option[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]]
    def orAllFilters
        : Option[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]]
    def notFilter: Option[zio.aws.kendra.model.AttributeFilter.ReadOnly]
    def equalsTo: Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def containsAll: Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def containsAny: Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def greaterThan: Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def greaterThanOrEquals
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def lessThan: Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def lessThanOrEquals
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly]
    def getAndAllFilters: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.AttributeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("andAllFilters", andAllFilters)
    def getOrAllFilters: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.AttributeFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("orAllFilters", orAllFilters)
    def getNotFilter
        : ZIO[Any, AwsError, zio.aws.kendra.model.AttributeFilter.ReadOnly] =
      AwsError.unwrapOptionField("notFilter", notFilter)
    def getEqualsTo
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("equalsTo", equalsTo)
    def getContainsAll
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("containsAll", containsAll)
    def getContainsAny
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("containsAny", containsAny)
    def getGreaterThan
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("greaterThan", greaterThan)
    def getGreaterThanOrEquals
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("greaterThanOrEquals", greaterThanOrEquals)
    def getLessThan
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("lessThan", lessThan)
    def getLessThanOrEquals
        : ZIO[Any, AwsError, zio.aws.kendra.model.DocumentAttribute.ReadOnly] =
      AwsError.unwrapOptionField("lessThanOrEquals", lessThanOrEquals)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AttributeFilter
  ) extends zio.aws.kendra.model.AttributeFilter.ReadOnly {
    override val andAllFilters
        : Option[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]] = scala
      .Option(impl.andAllFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.AttributeFilter.wrap(item)
        }.toList
      )
    override val orAllFilters
        : Option[List[zio.aws.kendra.model.AttributeFilter.ReadOnly]] = scala
      .Option(impl.orAllFilters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.AttributeFilter.wrap(item)
        }.toList
      )
    override val notFilter
        : Option[zio.aws.kendra.model.AttributeFilter.ReadOnly] = scala
      .Option(impl.notFilter())
      .map(value => zio.aws.kendra.model.AttributeFilter.wrap(value))
    override val equalsTo
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.equalsTo())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val containsAll
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.containsAll())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val containsAny
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.containsAny())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val greaterThan
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.greaterThan())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val greaterThanOrEquals
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.greaterThanOrEquals())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val lessThan
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.lessThan())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
    override val lessThanOrEquals
        : Option[zio.aws.kendra.model.DocumentAttribute.ReadOnly] = scala
      .Option(impl.lessThanOrEquals())
      .map(value => zio.aws.kendra.model.DocumentAttribute.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AttributeFilter
  ): zio.aws.kendra.model.AttributeFilter.ReadOnly = new Wrapper(impl)
}
