package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AuthenticationConfiguration(
    basicAuthentication: Option[
      Iterable[zio.aws.kendra.model.BasicAuthenticationConfiguration]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.AuthenticationConfiguration = {
    import AuthenticationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.AuthenticationConfiguration
      .builder()
      .optionallyWith(
        basicAuthentication.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.basicAuthentication)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly =
    zio.aws.kendra.model.AuthenticationConfiguration.wrap(buildAwsValue())
}
object AuthenticationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.AuthenticationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.AuthenticationConfiguration =
      zio.aws.kendra.model.AuthenticationConfiguration(
        basicAuthentication.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def basicAuthentication: Option[
      List[zio.aws.kendra.model.BasicAuthenticationConfiguration.ReadOnly]
    ]
    def getBasicAuthentication: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.BasicAuthenticationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField("basicAuthentication", basicAuthentication)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.AuthenticationConfiguration
  ) extends zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly {
    override val basicAuthentication: Option[
      List[zio.aws.kendra.model.BasicAuthenticationConfiguration.ReadOnly]
    ] = scala
      .Option(impl.basicAuthentication())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.BasicAuthenticationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.AuthenticationConfiguration
  ): zio.aws.kendra.model.AuthenticationConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
