package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{DocumentId, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDocumentRequest(
    indexId: IndexId,
    documentIdList: Iterable[DocumentId],
    dataSourceSyncJobMetricTarget: Option[
      zio.aws.kendra.model.DataSourceSyncJobMetricTarget
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest = {
    import BatchDeleteDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .documentIdList(documentIdList.map { item =>
        DocumentId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        dataSourceSyncJobMetricTarget.map(value => value.buildAwsValue())
      )(_.dataSourceSyncJobMetricTarget)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BatchDeleteDocumentRequest.ReadOnly =
    zio.aws.kendra.model.BatchDeleteDocumentRequest.wrap(buildAwsValue())
}
object BatchDeleteDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchDeleteDocumentRequest =
      zio.aws.kendra.model.BatchDeleteDocumentRequest(
        indexId,
        documentIdList,
        dataSourceSyncJobMetricTarget.map(value => value.asEditable)
      )
    def indexId: IndexId
    def documentIdList: List[DocumentId]
    def dataSourceSyncJobMetricTarget
        : Option[zio.aws.kendra.model.DataSourceSyncJobMetricTarget.ReadOnly]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDocumentIdList: ZIO[Any, Nothing, List[DocumentId]] =
      ZIO.succeed(documentIdList)
    def getDataSourceSyncJobMetricTarget: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceSyncJobMetricTarget.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataSourceSyncJobMetricTarget",
      dataSourceSyncJobMetricTarget
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest
  ) extends zio.aws.kendra.model.BatchDeleteDocumentRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val documentIdList: List[DocumentId] = impl
      .documentIdList()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.DocumentId(item)
      }
      .toList
    override val dataSourceSyncJobMetricTarget
        : Option[zio.aws.kendra.model.DataSourceSyncJobMetricTarget.ReadOnly] =
      scala
        .Option(impl.dataSourceSyncJobMetricTarget())
        .map(value =>
          zio.aws.kendra.model.DataSourceSyncJobMetricTarget.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentRequest
  ): zio.aws.kendra.model.BatchDeleteDocumentRequest.ReadOnly = new Wrapper(
    impl
  )
}
