package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDocumentResponse(
    failedDocuments: Option[
      Iterable[zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse = {
    import BatchDeleteDocumentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse
      .builder()
      .optionallyWith(
        failedDocuments.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedDocuments)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly =
    zio.aws.kendra.model.BatchDeleteDocumentResponse.wrap(buildAwsValue())
}
object BatchDeleteDocumentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchDeleteDocumentResponse =
      zio.aws.kendra.model.BatchDeleteDocumentResponse(
        failedDocuments.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def failedDocuments: Option[List[
      zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument.ReadOnly
    ]]
    def getFailedDocuments: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument.ReadOnly
    ]] = AwsError.unwrapOptionField("failedDocuments", failedDocuments)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse
  ) extends zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly {
    override val failedDocuments: Option[List[
      zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument.ReadOnly
    ]] = scala
      .Option(impl.failedDocuments())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponse
  ): zio.aws.kendra.model.BatchDeleteDocumentResponse.ReadOnly = new Wrapper(
    impl
  )
}
