package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ErrorMessage, DocumentId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchDeleteDocumentResponseFailedDocument(
    id: Option[DocumentId] = None,
    errorCode: Option[zio.aws.kendra.model.ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocument = {
    import BatchDeleteDocumentResponseFailedDocument.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocument
      .builder()
      .optionallyWith(
        id.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument.ReadOnly =
    zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument
      .wrap(buildAwsValue())
}
object BatchDeleteDocumentResponseFailedDocument {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocument
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument =
      zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument(
        id.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def id: Option[DocumentId]
    def errorCode: Option[zio.aws.kendra.model.ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("id", id)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.kendra.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocument
  ) extends zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument.ReadOnly {
    override val id: Option[DocumentId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val errorCode: Option[zio.aws.kendra.model.ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.kendra.model.ErrorCode.wrap(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchDeleteDocumentResponseFailedDocument
  ): zio.aws.kendra.model.BatchDeleteDocumentResponseFailedDocument.ReadOnly =
    new Wrapper(impl)
}
