package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ErrorMessage, DocumentId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchGetDocumentStatusResponseError(
    documentId: Option[DocumentId] = None,
    errorCode: Option[zio.aws.kendra.model.ErrorCode] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError = {
    import BatchGetDocumentStatusResponseError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
      .builder()
      .optionallyWith(
        documentId.map(value => DocumentId.unwrap(value): java.lang.String)
      )(_.documentId)
      .optionallyWith(errorCode.map(value => value.unwrap))(_.errorCode)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly =
    zio.aws.kendra.model.BatchGetDocumentStatusResponseError
      .wrap(buildAwsValue())
}
object BatchGetDocumentStatusResponseError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchGetDocumentStatusResponseError =
      zio.aws.kendra.model.BatchGetDocumentStatusResponseError(
        documentId.map(value => value),
        errorCode.map(value => value),
        errorMessage.map(value => value)
      )
    def documentId: Option[DocumentId]
    def errorCode: Option[zio.aws.kendra.model.ErrorCode]
    def errorMessage: Option[ErrorMessage]
    def getDocumentId: ZIO[Any, AwsError, DocumentId] =
      AwsError.unwrapOptionField("documentId", documentId)
    def getErrorCode: ZIO[Any, AwsError, zio.aws.kendra.model.ErrorCode] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
  ) extends zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly {
    override val documentId: Option[DocumentId] = scala
      .Option(impl.documentId())
      .map(value => zio.aws.kendra.model.primitives.DocumentId(value))
    override val errorCode: Option[zio.aws.kendra.model.ErrorCode] = scala
      .Option(impl.errorCode())
      .map(value => zio.aws.kendra.model.ErrorCode.wrap(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchGetDocumentStatusResponseError
  ): zio.aws.kendra.model.BatchGetDocumentStatusResponseError.ReadOnly =
    new Wrapper(impl)
}
