package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{RoleArn, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class BatchPutDocumentRequest(
    indexId: IndexId,
    roleArn: Option[RoleArn] = None,
    documents: Iterable[zio.aws.kendra.model.Document],
    customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest = {
    import BatchPutDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .documents(documents.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        customDocumentEnrichmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customDocumentEnrichmentConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.BatchPutDocumentRequest.ReadOnly =
    zio.aws.kendra.model.BatchPutDocumentRequest.wrap(buildAwsValue())
}
object BatchPutDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.BatchPutDocumentRequest =
      zio.aws.kendra.model.BatchPutDocumentRequest(
        indexId,
        roleArn.map(value => value),
        documents.map { item =>
          item.asEditable
        },
        customDocumentEnrichmentConfiguration.map(value => value.asEditable)
      )
    def indexId: IndexId
    def roleArn: Option[RoleArn]
    def documents: List[zio.aws.kendra.model.Document.ReadOnly]
    def customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getDocuments
        : ZIO[Any, Nothing, List[zio.aws.kendra.model.Document.ReadOnly]] =
      ZIO.succeed(documents)
    def getCustomDocumentEnrichmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDocumentEnrichmentConfiguration",
      customDocumentEnrichmentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest
  ) extends zio.aws.kendra.model.BatchPutDocumentRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val documents: List[zio.aws.kendra.model.Document.ReadOnly] = impl
      .documents()
      .asScala
      .map { item =>
        zio.aws.kendra.model.Document.wrap(item)
      }
      .toList
    override val customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = scala
      .Option(impl.customDocumentEnrichmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.BatchPutDocumentRequest
  ): zio.aws.kendra.model.BatchPutDocumentRequest.ReadOnly = new Wrapper(impl)
}
