package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.ColumnName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ColumnConfiguration(
    documentIdColumnName: ColumnName,
    documentDataColumnName: ColumnName,
    documentTitleColumnName: Option[ColumnName] = None,
    fieldMappings: Option[
      Iterable[zio.aws.kendra.model.DataSourceToIndexFieldMapping]
    ] = None,
    changeDetectingColumns: Iterable[ColumnName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ColumnConfiguration = {
    import ColumnConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ColumnConfiguration
      .builder()
      .documentIdColumnName(
        ColumnName.unwrap(documentIdColumnName): java.lang.String
      )
      .documentDataColumnName(
        ColumnName.unwrap(documentDataColumnName): java.lang.String
      )
      .optionallyWith(
        documentTitleColumnName.map(value =>
          ColumnName.unwrap(value): java.lang.String
        )
      )(_.documentTitleColumnName)
      .optionallyWith(
        fieldMappings.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.fieldMappings)
      .changeDetectingColumns(changeDetectingColumns.map { item =>
        ColumnName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ColumnConfiguration.ReadOnly =
    zio.aws.kendra.model.ColumnConfiguration.wrap(buildAwsValue())
}
object ColumnConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ColumnConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ColumnConfiguration =
      zio.aws.kendra.model.ColumnConfiguration(
        documentIdColumnName,
        documentDataColumnName,
        documentTitleColumnName.map(value => value),
        fieldMappings.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        changeDetectingColumns
      )
    def documentIdColumnName: ColumnName
    def documentDataColumnName: ColumnName
    def documentTitleColumnName: Option[ColumnName]
    def fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ]
    def changeDetectingColumns: List[ColumnName]
    def getDocumentIdColumnName: ZIO[Any, Nothing, ColumnName] =
      ZIO.succeed(documentIdColumnName)
    def getDocumentDataColumnName: ZIO[Any, Nothing, ColumnName] =
      ZIO.succeed(documentDataColumnName)
    def getDocumentTitleColumnName: ZIO[Any, AwsError, ColumnName] = AwsError
      .unwrapOptionField("documentTitleColumnName", documentTitleColumnName)
    def getFieldMappings: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly
    ]] = AwsError.unwrapOptionField("fieldMappings", fieldMappings)
    def getChangeDetectingColumns: ZIO[Any, Nothing, List[ColumnName]] =
      ZIO.succeed(changeDetectingColumns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ColumnConfiguration
  ) extends zio.aws.kendra.model.ColumnConfiguration.ReadOnly {
    override val documentIdColumnName: ColumnName =
      zio.aws.kendra.model.primitives.ColumnName(impl.documentIdColumnName())
    override val documentDataColumnName: ColumnName =
      zio.aws.kendra.model.primitives.ColumnName(impl.documentDataColumnName())
    override val documentTitleColumnName: Option[ColumnName] = scala
      .Option(impl.documentTitleColumnName())
      .map(value => zio.aws.kendra.model.primitives.ColumnName(value))
    override val fieldMappings: Option[
      List[zio.aws.kendra.model.DataSourceToIndexFieldMapping.ReadOnly]
    ] = scala
      .Option(impl.fieldMappings())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DataSourceToIndexFieldMapping.wrap(item)
        }.toList
      )
    override val changeDetectingColumns: List[ColumnName] = impl
      .changeDetectingColumns()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.ColumnName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ColumnConfiguration
  ): zio.aws.kendra.model.ColumnConfiguration.ReadOnly = new Wrapper(impl)
}
