package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  IndexFieldName,
  DataSourceDateFieldFormat
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfluenceAttachmentToIndexFieldMapping(
    dataSourceFieldName: Option[
      zio.aws.kendra.model.ConfluenceAttachmentFieldName
    ] = None,
    dateFieldFormat: Option[DataSourceDateFieldFormat] = None,
    indexFieldName: Option[IndexFieldName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping = {
    import ConfluenceAttachmentToIndexFieldMapping.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping
      .builder()
      .optionallyWith(dataSourceFieldName.map(value => value.unwrap))(
        _.dataSourceFieldName
      )
      .optionallyWith(
        dateFieldFormat.map(value =>
          DataSourceDateFieldFormat.unwrap(value): java.lang.String
        )
      )(_.dateFieldFormat)
      .optionallyWith(
        indexFieldName.map(value =>
          IndexFieldName.unwrap(value): java.lang.String
        )
      )(_.indexFieldName)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping.ReadOnly =
    zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping
      .wrap(buildAwsValue())
}
object ConfluenceAttachmentToIndexFieldMapping {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping =
      zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping(
        dataSourceFieldName.map(value => value),
        dateFieldFormat.map(value => value),
        indexFieldName.map(value => value)
      )
    def dataSourceFieldName
        : Option[zio.aws.kendra.model.ConfluenceAttachmentFieldName]
    def dateFieldFormat: Option[DataSourceDateFieldFormat]
    def indexFieldName: Option[IndexFieldName]
    def getDataSourceFieldName: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluenceAttachmentFieldName
    ] = AwsError.unwrapOptionField("dataSourceFieldName", dataSourceFieldName)
    def getDateFieldFormat: ZIO[Any, AwsError, DataSourceDateFieldFormat] =
      AwsError.unwrapOptionField("dateFieldFormat", dateFieldFormat)
    def getIndexFieldName: ZIO[Any, AwsError, IndexFieldName] =
      AwsError.unwrapOptionField("indexFieldName", indexFieldName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping
  ) extends zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping.ReadOnly {
    override val dataSourceFieldName
        : Option[zio.aws.kendra.model.ConfluenceAttachmentFieldName] = scala
      .Option(impl.dataSourceFieldName())
      .map(value =>
        zio.aws.kendra.model.ConfluenceAttachmentFieldName.wrap(value)
      )
    override val dateFieldFormat: Option[DataSourceDateFieldFormat] = scala
      .Option(impl.dateFieldFormat())
      .map(value =>
        zio.aws.kendra.model.primitives.DataSourceDateFieldFormat(value)
      )
    override val indexFieldName: Option[IndexFieldName] = scala
      .Option(impl.indexFieldName())
      .map(value => zio.aws.kendra.model.primitives.IndexFieldName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceAttachmentToIndexFieldMapping
  ): zio.aws.kendra.model.ConfluenceAttachmentToIndexFieldMapping.ReadOnly =
    new Wrapper(impl)
}
