package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  DataSourceInclusionsExclusionsStringsMember,
  SecretArn,
  Url
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfluenceConfiguration(
    serverUrl: Url,
    secretArn: SecretArn,
    version: zio.aws.kendra.model.ConfluenceVersion,
    spaceConfiguration: Option[
      zio.aws.kendra.model.ConfluenceSpaceConfiguration
    ] = None,
    pageConfiguration: Option[
      zio.aws.kendra.model.ConfluencePageConfiguration
    ] = None,
    blogConfiguration: Option[
      zio.aws.kendra.model.ConfluenceBlogConfiguration
    ] = None,
    attachmentConfiguration: Option[
      zio.aws.kendra.model.ConfluenceAttachmentConfiguration
    ] = None,
    vpcConfiguration: Option[zio.aws.kendra.model.DataSourceVpcConfiguration] =
      None,
    inclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None,
    exclusionPatterns: Option[
      Iterable[DataSourceInclusionsExclusionsStringsMember]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ConfluenceConfiguration = {
    import ConfluenceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ConfluenceConfiguration
      .builder()
      .serverUrl(Url.unwrap(serverUrl): java.lang.String)
      .secretArn(SecretArn.unwrap(secretArn): java.lang.String)
      .version(version.unwrap)
      .optionallyWith(spaceConfiguration.map(value => value.buildAwsValue()))(
        _.spaceConfiguration
      )
      .optionallyWith(pageConfiguration.map(value => value.buildAwsValue()))(
        _.pageConfiguration
      )
      .optionallyWith(blogConfiguration.map(value => value.buildAwsValue()))(
        _.blogConfiguration
      )
      .optionallyWith(
        attachmentConfiguration.map(value => value.buildAwsValue())
      )(_.attachmentConfiguration)
      .optionallyWith(vpcConfiguration.map(value => value.buildAwsValue()))(
        _.vpcConfiguration
      )
      .optionallyWith(
        inclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.inclusionPatterns)
      .optionallyWith(
        exclusionPatterns.map(value =>
          value.map { item =>
            DataSourceInclusionsExclusionsStringsMember.unwrap(
              item
            ): java.lang.String
          }.asJavaCollection
        )
      )(_.exclusionPatterns)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly =
    zio.aws.kendra.model.ConfluenceConfiguration.wrap(buildAwsValue())
}
object ConfluenceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ConfluenceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ConfluenceConfiguration =
      zio.aws.kendra.model.ConfluenceConfiguration(
        serverUrl,
        secretArn,
        version,
        spaceConfiguration.map(value => value.asEditable),
        pageConfiguration.map(value => value.asEditable),
        blogConfiguration.map(value => value.asEditable),
        attachmentConfiguration.map(value => value.asEditable),
        vpcConfiguration.map(value => value.asEditable),
        inclusionPatterns.map(value => value),
        exclusionPatterns.map(value => value)
      )
    def serverUrl: Url
    def secretArn: SecretArn
    def version: zio.aws.kendra.model.ConfluenceVersion
    def spaceConfiguration
        : Option[zio.aws.kendra.model.ConfluenceSpaceConfiguration.ReadOnly]
    def pageConfiguration
        : Option[zio.aws.kendra.model.ConfluencePageConfiguration.ReadOnly]
    def blogConfiguration
        : Option[zio.aws.kendra.model.ConfluenceBlogConfiguration.ReadOnly]
    def attachmentConfiguration: Option[
      zio.aws.kendra.model.ConfluenceAttachmentConfiguration.ReadOnly
    ]
    def vpcConfiguration
        : Option[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly]
    def inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]]
    def getServerUrl: ZIO[Any, Nothing, Url] = ZIO.succeed(serverUrl)
    def getSecretArn: ZIO[Any, Nothing, SecretArn] = ZIO.succeed(secretArn)
    def getVersion: ZIO[Any, Nothing, zio.aws.kendra.model.ConfluenceVersion] =
      ZIO.succeed(version)
    def getSpaceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluenceSpaceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("spaceConfiguration", spaceConfiguration)
    def getPageConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluencePageConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("pageConfiguration", pageConfiguration)
    def getBlogConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluenceBlogConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("blogConfiguration", blogConfiguration)
    def getAttachmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluenceAttachmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "attachmentConfiguration",
      attachmentConfiguration
    )
    def getVpcConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("vpcConfiguration", vpcConfiguration)
    def getInclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("inclusionPatterns", inclusionPatterns)
    def getExclusionPatterns: ZIO[Any, AwsError, List[
      DataSourceInclusionsExclusionsStringsMember
    ]] = AwsError.unwrapOptionField("exclusionPatterns", exclusionPatterns)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceConfiguration
  ) extends zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly {
    override val serverUrl: Url =
      zio.aws.kendra.model.primitives.Url(impl.serverUrl())
    override val secretArn: SecretArn =
      zio.aws.kendra.model.primitives.SecretArn(impl.secretArn())
    override val version: zio.aws.kendra.model.ConfluenceVersion =
      zio.aws.kendra.model.ConfluenceVersion.wrap(impl.version())
    override val spaceConfiguration
        : Option[zio.aws.kendra.model.ConfluenceSpaceConfiguration.ReadOnly] =
      scala
        .Option(impl.spaceConfiguration())
        .map(value =>
          zio.aws.kendra.model.ConfluenceSpaceConfiguration.wrap(value)
        )
    override val pageConfiguration
        : Option[zio.aws.kendra.model.ConfluencePageConfiguration.ReadOnly] =
      scala
        .Option(impl.pageConfiguration())
        .map(value =>
          zio.aws.kendra.model.ConfluencePageConfiguration.wrap(value)
        )
    override val blogConfiguration
        : Option[zio.aws.kendra.model.ConfluenceBlogConfiguration.ReadOnly] =
      scala
        .Option(impl.blogConfiguration())
        .map(value =>
          zio.aws.kendra.model.ConfluenceBlogConfiguration.wrap(value)
        )
    override val attachmentConfiguration: Option[
      zio.aws.kendra.model.ConfluenceAttachmentConfiguration.ReadOnly
    ] = scala
      .Option(impl.attachmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.ConfluenceAttachmentConfiguration.wrap(value)
      )
    override val vpcConfiguration
        : Option[zio.aws.kendra.model.DataSourceVpcConfiguration.ReadOnly] =
      scala
        .Option(impl.vpcConfiguration())
        .map(value =>
          zio.aws.kendra.model.DataSourceVpcConfiguration.wrap(value)
        )
    override val inclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.inclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
    override val exclusionPatterns
        : Option[List[DataSourceInclusionsExclusionsStringsMember]] = scala
      .Option(impl.exclusionPatterns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives
            .DataSourceInclusionsExclusionsStringsMember(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ConfluenceConfiguration
  ): zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly = new Wrapper(impl)
}
