package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{FaqId, DataSourceId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ContentSourceConfiguration(
    dataSourceIds: Option[Iterable[DataSourceId]] = None,
    faqIds: Option[Iterable[FaqId]] = None,
    directPutContent: Option[Boolean] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ContentSourceConfiguration = {
    import ContentSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ContentSourceConfiguration
      .builder()
      .optionallyWith(
        dataSourceIds.map(value =>
          value.map { item =>
            DataSourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dataSourceIds)
      .optionallyWith(
        faqIds.map(value =>
          value.map { item =>
            FaqId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.faqIds)
      .optionallyWith(directPutContent.map(value => value: java.lang.Boolean))(
        _.directPutContent
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ContentSourceConfiguration.ReadOnly =
    zio.aws.kendra.model.ContentSourceConfiguration.wrap(buildAwsValue())
}
object ContentSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ContentSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ContentSourceConfiguration =
      zio.aws.kendra.model.ContentSourceConfiguration(
        dataSourceIds.map(value => value),
        faqIds.map(value => value),
        directPutContent.map(value => value)
      )
    def dataSourceIds: Option[List[DataSourceId]]
    def faqIds: Option[List[FaqId]]
    def directPutContent: Option[Boolean]
    def getDataSourceIds: ZIO[Any, AwsError, List[DataSourceId]] =
      AwsError.unwrapOptionField("dataSourceIds", dataSourceIds)
    def getFaqIds: ZIO[Any, AwsError, List[FaqId]] =
      AwsError.unwrapOptionField("faqIds", faqIds)
    def getDirectPutContent: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("directPutContent", directPutContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ContentSourceConfiguration
  ) extends zio.aws.kendra.model.ContentSourceConfiguration.ReadOnly {
    override val dataSourceIds: Option[List[DataSourceId]] = scala
      .Option(impl.dataSourceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.DataSourceId(item)
        }.toList
      )
    override val faqIds: Option[List[FaqId]] = scala
      .Option(impl.faqIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.primitives.FaqId(item)
        }.toList
      )
    override val directPutContent: Option[Boolean] =
      scala.Option(impl.directPutContent()).map(value => value: Boolean)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ContentSourceConfiguration
  ): zio.aws.kendra.model.ContentSourceConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
