package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait ContentType {
  def unwrap: software.amazon.awssdk.services.kendra.model.ContentType
}
object ContentType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.ContentType
  ): zio.aws.kendra.model.ContentType = value match {
    case software.amazon.awssdk.services.kendra.model.ContentType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.ContentType.PDF =>
      val r = PDF
      r
    case software.amazon.awssdk.services.kendra.model.ContentType.HTML =>
      val r = HTML
      r
    case software.amazon.awssdk.services.kendra.model.ContentType.MS_WORD =>
      val r = MS_WORD
      r
    case software.amazon.awssdk.services.kendra.model.ContentType.PLAIN_TEXT =>
      val r = PLAIN_TEXT
      r
    case software.amazon.awssdk.services.kendra.model.ContentType.PPT =>
      val r = PPT
      r
  }
  case object unknownToSdkVersion extends zio.aws.kendra.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ContentType =
      software.amazon.awssdk.services.kendra.model.ContentType.UNKNOWN_TO_SDK_VERSION
  }
  case object PDF extends zio.aws.kendra.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ContentType =
      software.amazon.awssdk.services.kendra.model.ContentType.PDF
  }
  case object HTML extends zio.aws.kendra.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ContentType =
      software.amazon.awssdk.services.kendra.model.ContentType.HTML
  }
  case object MS_WORD extends zio.aws.kendra.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ContentType =
      software.amazon.awssdk.services.kendra.model.ContentType.MS_WORD
  }
  case object PLAIN_TEXT extends zio.aws.kendra.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ContentType =
      software.amazon.awssdk.services.kendra.model.ContentType.PLAIN_TEXT
  }
  case object PPT extends zio.aws.kendra.model.ContentType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.ContentType =
      software.amazon.awssdk.services.kendra.model.ContentType.PPT
  }
}
