package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Correction(
    beginOffset: Option[Integer] = None,
    endOffset: Option[Integer] = None,
    term: Option[String] = None,
    correctedTerm: Option[String] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.Correction = {
    import Correction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Correction
      .builder()
      .optionallyWith(beginOffset.map(value => value: java.lang.Integer))(
        _.beginOffset
      )
      .optionallyWith(endOffset.map(value => value: java.lang.Integer))(
        _.endOffset
      )
      .optionallyWith(term.map(value => value: java.lang.String))(_.term)
      .optionallyWith(correctedTerm.map(value => value: java.lang.String))(
        _.correctedTerm
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Correction.ReadOnly =
    zio.aws.kendra.model.Correction.wrap(buildAwsValue())
}
object Correction {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Correction] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Correction =
      zio.aws.kendra.model.Correction(
        beginOffset.map(value => value),
        endOffset.map(value => value),
        term.map(value => value),
        correctedTerm.map(value => value)
      )
    def beginOffset: Option[Integer]
    def endOffset: Option[Integer]
    def term: Option[String]
    def correctedTerm: Option[String]
    def getBeginOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("beginOffset", beginOffset)
    def getEndOffset: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("endOffset", endOffset)
    def getTerm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("term", term)
    def getCorrectedTerm: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("correctedTerm", correctedTerm)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Correction
  ) extends zio.aws.kendra.model.Correction.ReadOnly {
    override val beginOffset: Option[Integer] =
      scala.Option(impl.beginOffset()).map(value => value: Integer)
    override val endOffset: Option[Integer] =
      scala.Option(impl.endOffset()).map(value => value: Integer)
    override val term: Option[String] =
      scala.Option(impl.term()).map(value => value: String)
    override val correctedTerm: Option[String] =
      scala.Option(impl.correctedTerm()).map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Correction
  ): zio.aws.kendra.model.Correction.ReadOnly = new Wrapper(impl)
}
