package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  RoleArn,
  DataSourceName,
  LanguageCode,
  IndexId,
  Description,
  ScanSchedule
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateDataSourceRequest(
    name: DataSourceName,
    indexId: IndexId,
    `type`: zio.aws.kendra.model.DataSourceType,
    configuration: Option[zio.aws.kendra.model.DataSourceConfiguration] = None,
    description: Option[Description] = None,
    schedule: Option[ScanSchedule] = None,
    roleArn: Option[RoleArn] = None,
    tags: Option[Iterable[zio.aws.kendra.model.Tag]] = None,
    clientToken: Option[ClientTokenName] = None,
    languageCode: Option[LanguageCode] = None,
    customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest = {
    import CreateDataSourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest
      .builder()
      .name(DataSourceName.unwrap(name): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        schedule.map(value => ScanSchedule.unwrap(value): java.lang.String)
      )(_.schedule)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        customDocumentEnrichmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customDocumentEnrichmentConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateDataSourceRequest.ReadOnly =
    zio.aws.kendra.model.CreateDataSourceRequest.wrap(buildAwsValue())
}
object CreateDataSourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateDataSourceRequest =
      zio.aws.kendra.model.CreateDataSourceRequest(
        name,
        indexId,
        `type`,
        configuration.map(value => value.asEditable),
        description.map(value => value),
        schedule.map(value => value),
        roleArn.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        clientToken.map(value => value),
        languageCode.map(value => value),
        customDocumentEnrichmentConfiguration.map(value => value.asEditable)
      )
    def name: DataSourceName
    def indexId: IndexId
    def `type`: zio.aws.kendra.model.DataSourceType
    def configuration
        : Option[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly]
    def description: Option[Description]
    def schedule: Option[ScanSchedule]
    def roleArn: Option[RoleArn]
    def tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def clientToken: Option[ClientTokenName]
    def languageCode: Option[LanguageCode]
    def customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ]
    def getName: ZIO[Any, Nothing, DataSourceName] = ZIO.succeed(name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getType: ZIO[Any, Nothing, zio.aws.kendra.model.DataSourceType] =
      ZIO.succeed(`type`)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSchedule: ZIO[Any, AwsError, ScanSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getCustomDocumentEnrichmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDocumentEnrichmentConfiguration",
      customDocumentEnrichmentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest
  ) extends zio.aws.kendra.model.CreateDataSourceRequest.ReadOnly {
    override val name: DataSourceName =
      zio.aws.kendra.model.primitives.DataSourceName(impl.name())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val `type`: zio.aws.kendra.model.DataSourceType =
      zio.aws.kendra.model.DataSourceType.wrap(impl.`type`())
    override val configuration
        : Option[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.kendra.model.DataSourceConfiguration.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val schedule: Option[ScanSchedule] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.kendra.model.primitives.ScanSchedule(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Tag.wrap(item)
        }.toList
      )
    override val clientToken: Option[ClientTokenName] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
    override val customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = scala
      .Option(impl.customDocumentEnrichmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateDataSourceRequest
  ): zio.aws.kendra.model.CreateDataSourceRequest.ReadOnly = new Wrapper(impl)
}
