package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ExperienceName,
  ClientTokenName,
  RoleArn,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateExperienceRequest(
    name: ExperienceName,
    indexId: IndexId,
    roleArn: Option[RoleArn] = None,
    configuration: Option[zio.aws.kendra.model.ExperienceConfiguration] = None,
    description: Option[Description] = None,
    clientToken: Option[ClientTokenName] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateExperienceRequest = {
    import CreateExperienceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateExperienceRequest
      .builder()
      .name(ExperienceName.unwrap(name): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateExperienceRequest.ReadOnly =
    zio.aws.kendra.model.CreateExperienceRequest.wrap(buildAwsValue())
}
object CreateExperienceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateExperienceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateExperienceRequest =
      zio.aws.kendra.model.CreateExperienceRequest(
        name,
        indexId,
        roleArn.map(value => value),
        configuration.map(value => value.asEditable),
        description.map(value => value),
        clientToken.map(value => value)
      )
    def name: ExperienceName
    def indexId: IndexId
    def roleArn: Option[RoleArn]
    def configuration
        : Option[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly]
    def description: Option[Description]
    def clientToken: Option[ClientTokenName]
    def getName: ZIO[Any, Nothing, ExperienceName] = ZIO.succeed(name)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperienceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateExperienceRequest
  ) extends zio.aws.kendra.model.CreateExperienceRequest.ReadOnly {
    override val name: ExperienceName =
      zio.aws.kendra.model.primitives.ExperienceName(impl.name())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val configuration
        : Option[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.kendra.model.ExperienceConfiguration.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val clientToken: Option[ClientTokenName] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateExperienceRequest
  ): zio.aws.kendra.model.CreateExperienceRequest.ReadOnly = new Wrapper(impl)
}
