package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  RoleArn,
  LanguageCode,
  FaqName,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateFaqRequest(
    indexId: IndexId,
    name: FaqName,
    description: Option[Description] = None,
    s3Path: zio.aws.kendra.model.S3Path,
    roleArn: RoleArn,
    tags: Option[Iterable[zio.aws.kendra.model.Tag]] = None,
    fileFormat: Option[zio.aws.kendra.model.FaqFileFormat] = None,
    clientToken: Option[ClientTokenName] = None,
    languageCode: Option[LanguageCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateFaqRequest = {
    import CreateFaqRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateFaqRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .name(FaqName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .s3Path(s3Path.buildAwsValue())
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateFaqRequest.ReadOnly =
    zio.aws.kendra.model.CreateFaqRequest.wrap(buildAwsValue())
}
object CreateFaqRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateFaqRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateFaqRequest =
      zio.aws.kendra.model.CreateFaqRequest(
        indexId,
        name,
        description.map(value => value),
        s3Path.asEditable,
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        fileFormat.map(value => value),
        clientToken.map(value => value),
        languageCode.map(value => value)
      )
    def indexId: IndexId
    def name: FaqName
    def description: Option[Description]
    def s3Path: zio.aws.kendra.model.S3Path.ReadOnly
    def roleArn: RoleArn
    def tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def fileFormat: Option[zio.aws.kendra.model.FaqFileFormat]
    def clientToken: Option[ClientTokenName]
    def languageCode: Option[LanguageCode]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getName: ZIO[Any, Nothing, FaqName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getS3Path: ZIO[Any, Nothing, zio.aws.kendra.model.S3Path.ReadOnly] =
      ZIO.succeed(s3Path)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getFileFormat: ZIO[Any, AwsError, zio.aws.kendra.model.FaqFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateFaqRequest
  ) extends zio.aws.kendra.model.CreateFaqRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val name: FaqName =
      zio.aws.kendra.model.primitives.FaqName(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val s3Path: zio.aws.kendra.model.S3Path.ReadOnly =
      zio.aws.kendra.model.S3Path.wrap(impl.s3Path())
    override val roleArn: RoleArn =
      zio.aws.kendra.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Tag.wrap(item)
        }.toList
      )
    override val fileFormat: Option[zio.aws.kendra.model.FaqFileFormat] = scala
      .Option(impl.fileFormat())
      .map(value => zio.aws.kendra.model.FaqFileFormat.wrap(value))
    override val clientToken: Option[ClientTokenName] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateFaqRequest
  ): zio.aws.kendra.model.CreateFaqRequest.ReadOnly = new Wrapper(impl)
}
