package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  Description,
  RoleArn,
  IndexName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIndexRequest(
    name: IndexName,
    edition: Option[zio.aws.kendra.model.IndexEdition] = None,
    roleArn: RoleArn,
    serverSideEncryptionConfiguration: Option[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration
    ] = None,
    description: Option[Description] = None,
    clientToken: Option[ClientTokenName] = None,
    tags: Option[Iterable[zio.aws.kendra.model.Tag]] = None,
    userTokenConfigurations: Option[
      Iterable[zio.aws.kendra.model.UserTokenConfiguration]
    ] = None,
    userContextPolicy: Option[zio.aws.kendra.model.UserContextPolicy] = None,
    userGroupResolutionConfiguration: Option[
      zio.aws.kendra.model.UserGroupResolutionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateIndexRequest = {
    import CreateIndexRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateIndexRequest
      .builder()
      .name(IndexName.unwrap(name): java.lang.String)
      .optionallyWith(edition.map(value => value.unwrap))(_.edition)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userTokenConfigurations)
      .optionallyWith(userContextPolicy.map(value => value.unwrap))(
        _.userContextPolicy
      )
      .optionallyWith(
        userGroupResolutionConfiguration.map(value => value.buildAwsValue())
      )(_.userGroupResolutionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateIndexRequest.ReadOnly =
    zio.aws.kendra.model.CreateIndexRequest.wrap(buildAwsValue())
}
object CreateIndexRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateIndexRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateIndexRequest =
      zio.aws.kendra.model.CreateIndexRequest(
        name,
        edition.map(value => value),
        roleArn,
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        description.map(value => value),
        clientToken.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userContextPolicy.map(value => value),
        userGroupResolutionConfiguration.map(value => value.asEditable)
      )
    def name: IndexName
    def edition: Option[zio.aws.kendra.model.IndexEdition]
    def roleArn: RoleArn
    def serverSideEncryptionConfiguration: Option[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def description: Option[Description]
    def clientToken: Option[ClientTokenName]
    def tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def userTokenConfigurations
        : Option[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]]
    def userContextPolicy: Option[zio.aws.kendra.model.UserContextPolicy]
    def userGroupResolutionConfiguration
        : Option[zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly]
    def getName: ZIO[Any, Nothing, IndexName] = ZIO.succeed(name)
    def getEdition: ZIO[Any, AwsError, zio.aws.kendra.model.IndexEdition] =
      AwsError.unwrapOptionField("edition", edition)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getUserTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.UserTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userTokenConfigurations",
      userTokenConfigurations
    )
    def getUserContextPolicy
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContextPolicy] =
      AwsError.unwrapOptionField("userContextPolicy", userContextPolicy)
    def getUserGroupResolutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userGroupResolutionConfiguration",
      userGroupResolutionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateIndexRequest
  ) extends zio.aws.kendra.model.CreateIndexRequest.ReadOnly {
    override val name: IndexName =
      zio.aws.kendra.model.primitives.IndexName(impl.name())
    override val edition: Option[zio.aws.kendra.model.IndexEdition] = scala
      .Option(impl.edition())
      .map(value => zio.aws.kendra.model.IndexEdition.wrap(value))
    override val roleArn: RoleArn =
      zio.aws.kendra.model.primitives.RoleArn(impl.roleArn())
    override val serverSideEncryptionConfiguration: Option[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.kendra.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val clientToken: Option[ClientTokenName] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Tag.wrap(item)
        }.toList
      )
    override val userTokenConfigurations
        : Option[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]] =
      scala
        .Option(impl.userTokenConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.UserTokenConfiguration.wrap(item)
          }.toList
        )
    override val userContextPolicy
        : Option[zio.aws.kendra.model.UserContextPolicy] = scala
      .Option(impl.userContextPolicy())
      .map(value => zio.aws.kendra.model.UserContextPolicy.wrap(value))
    override val userGroupResolutionConfiguration: Option[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = scala
      .Option(impl.userGroupResolutionConfiguration())
      .map(value =>
        zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateIndexRequest
  ): zio.aws.kendra.model.CreateIndexRequest.ReadOnly = new Wrapper(impl)
}
