package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.IndexId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateIndexResponse(id: Option[IndexId] = None) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateIndexResponse = {
    import CreateIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateIndexResponse
      .builder()
      .optionallyWith(id.map(value => IndexId.unwrap(value): java.lang.String))(
        _.id
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.CreateIndexResponse.ReadOnly =
    zio.aws.kendra.model.CreateIndexResponse.wrap(buildAwsValue())
}
object CreateIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CreateIndexResponse =
      zio.aws.kendra.model.CreateIndexResponse(id.map(value => value))
    def id: Option[IndexId]
    def getId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateIndexResponse
  ) extends zio.aws.kendra.model.CreateIndexResponse.ReadOnly {
    override val id: Option[IndexId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateIndexResponse
  ): zio.aws.kendra.model.CreateIndexResponse.ReadOnly = new Wrapper(impl)
}
