package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ClientTokenName,
  RoleArn,
  IndexId,
  Description,
  QuerySuggestionsBlockListName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateQuerySuggestionsBlockListRequest(
    indexId: IndexId,
    name: QuerySuggestionsBlockListName,
    description: Option[Description] = None,
    sourceS3Path: zio.aws.kendra.model.S3Path,
    clientToken: Option[ClientTokenName] = None,
    roleArn: RoleArn,
    tags: Option[Iterable[zio.aws.kendra.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest = {
    import CreateQuerySuggestionsBlockListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .name(QuerySuggestionsBlockListName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .sourceS3Path(sourceS3Path.buildAwsValue())
      .optionallyWith(
        clientToken.map(value =>
          ClientTokenName.unwrap(value): java.lang.String
        )
      )(_.clientToken)
      .roleArn(RoleArn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest.ReadOnly =
    zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest
      .wrap(buildAwsValue())
}
object CreateQuerySuggestionsBlockListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest =
      zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest(
        indexId,
        name,
        description.map(value => value),
        sourceS3Path.asEditable,
        clientToken.map(value => value),
        roleArn,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def indexId: IndexId
    def name: QuerySuggestionsBlockListName
    def description: Option[Description]
    def sourceS3Path: zio.aws.kendra.model.S3Path.ReadOnly
    def clientToken: Option[ClientTokenName]
    def roleArn: RoleArn
    def tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getName: ZIO[Any, Nothing, QuerySuggestionsBlockListName] =
      ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getSourceS3Path
        : ZIO[Any, Nothing, zio.aws.kendra.model.S3Path.ReadOnly] =
      ZIO.succeed(sourceS3Path)
    def getClientToken: ZIO[Any, AwsError, ClientTokenName] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getRoleArn: ZIO[Any, Nothing, RoleArn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, List[zio.aws.kendra.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest
  ) extends zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val name: QuerySuggestionsBlockListName =
      zio.aws.kendra.model.primitives.QuerySuggestionsBlockListName(impl.name())
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val sourceS3Path: zio.aws.kendra.model.S3Path.ReadOnly =
      zio.aws.kendra.model.S3Path.wrap(impl.sourceS3Path())
    override val clientToken: Option[ClientTokenName] = scala
      .Option(impl.clientToken())
      .map(value => zio.aws.kendra.model.primitives.ClientTokenName(value))
    override val roleArn: RoleArn =
      zio.aws.kendra.model.primitives.RoleArn(impl.roleArn())
    override val tags: Option[List[zio.aws.kendra.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CreateQuerySuggestionsBlockListRequest
  ): zio.aws.kendra.model.CreateQuerySuggestionsBlockListRequest.ReadOnly =
    new Wrapper(impl)
}
