package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.RoleArn
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CustomDocumentEnrichmentConfiguration(
    inlineConfigurations: Option[
      Iterable[zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration]
    ] = None,
    preExtractionHookConfiguration: Option[
      zio.aws.kendra.model.HookConfiguration
    ] = None,
    postExtractionHookConfiguration: Option[
      zio.aws.kendra.model.HookConfiguration
    ] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration = {
    import CustomDocumentEnrichmentConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
      .builder()
      .optionallyWith(
        inlineConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.inlineConfigurations)
      .optionallyWith(
        preExtractionHookConfiguration.map(value => value.buildAwsValue())
      )(_.preExtractionHookConfiguration)
      .optionallyWith(
        postExtractionHookConfiguration.map(value => value.buildAwsValue())
      )(_.postExtractionHookConfiguration)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly =
    zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
      .wrap(buildAwsValue())
}
object CustomDocumentEnrichmentConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration =
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration(
        inlineConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        preExtractionHookConfiguration.map(value => value.asEditable),
        postExtractionHookConfiguration.map(value => value.asEditable),
        roleArn.map(value => value)
      )
    def inlineConfigurations: Option[List[
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly
    ]]
    def preExtractionHookConfiguration
        : Option[zio.aws.kendra.model.HookConfiguration.ReadOnly]
    def postExtractionHookConfiguration
        : Option[zio.aws.kendra.model.HookConfiguration.ReadOnly]
    def roleArn: Option[RoleArn]
    def getInlineConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly
    ]] =
      AwsError.unwrapOptionField("inlineConfigurations", inlineConfigurations)
    def getPreExtractionHookConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.HookConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "preExtractionHookConfiguration",
        preExtractionHookConfiguration
      )
    def getPostExtractionHookConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.HookConfiguration.ReadOnly] =
      AwsError.unwrapOptionField(
        "postExtractionHookConfiguration",
        postExtractionHookConfiguration
      )
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
  ) extends zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly {
    override val inlineConfigurations: Option[List[
      zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration.ReadOnly
    ]] = scala
      .Option(impl.inlineConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.InlineCustomDocumentEnrichmentConfiguration
            .wrap(item)
        }.toList
      )
    override val preExtractionHookConfiguration
        : Option[zio.aws.kendra.model.HookConfiguration.ReadOnly] = scala
      .Option(impl.preExtractionHookConfiguration())
      .map(value => zio.aws.kendra.model.HookConfiguration.wrap(value))
    override val postExtractionHookConfiguration
        : Option[zio.aws.kendra.model.HookConfiguration.ReadOnly] = scala
      .Option(impl.postExtractionHookConfiguration())
      .map(value => zio.aws.kendra.model.HookConfiguration.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.CustomDocumentEnrichmentConfiguration
  ): zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly =
    new Wrapper(impl)
}
