package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataSourceConfiguration(
    s3Configuration: Option[zio.aws.kendra.model.S3DataSourceConfiguration] =
      None,
    sharePointConfiguration: Option[
      zio.aws.kendra.model.SharePointConfiguration
    ] = None,
    databaseConfiguration: Option[zio.aws.kendra.model.DatabaseConfiguration] =
      None,
    salesforceConfiguration: Option[
      zio.aws.kendra.model.SalesforceConfiguration
    ] = None,
    oneDriveConfiguration: Option[zio.aws.kendra.model.OneDriveConfiguration] =
      None,
    serviceNowConfiguration: Option[
      zio.aws.kendra.model.ServiceNowConfiguration
    ] = None,
    confluenceConfiguration: Option[
      zio.aws.kendra.model.ConfluenceConfiguration
    ] = None,
    googleDriveConfiguration: Option[
      zio.aws.kendra.model.GoogleDriveConfiguration
    ] = None,
    webCrawlerConfiguration: Option[
      zio.aws.kendra.model.WebCrawlerConfiguration
    ] = None,
    workDocsConfiguration: Option[zio.aws.kendra.model.WorkDocsConfiguration] =
      None,
    fsxConfiguration: Option[zio.aws.kendra.model.FsxConfiguration] = None,
    slackConfiguration: Option[zio.aws.kendra.model.SlackConfiguration] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceConfiguration = {
    import DataSourceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
      .builder()
      .optionallyWith(s3Configuration.map(value => value.buildAwsValue()))(
        _.s3Configuration
      )
      .optionallyWith(
        sharePointConfiguration.map(value => value.buildAwsValue())
      )(_.sharePointConfiguration)
      .optionallyWith(
        databaseConfiguration.map(value => value.buildAwsValue())
      )(_.databaseConfiguration)
      .optionallyWith(
        salesforceConfiguration.map(value => value.buildAwsValue())
      )(_.salesforceConfiguration)
      .optionallyWith(
        oneDriveConfiguration.map(value => value.buildAwsValue())
      )(_.oneDriveConfiguration)
      .optionallyWith(
        serviceNowConfiguration.map(value => value.buildAwsValue())
      )(_.serviceNowConfiguration)
      .optionallyWith(
        confluenceConfiguration.map(value => value.buildAwsValue())
      )(_.confluenceConfiguration)
      .optionallyWith(
        googleDriveConfiguration.map(value => value.buildAwsValue())
      )(_.googleDriveConfiguration)
      .optionallyWith(
        webCrawlerConfiguration.map(value => value.buildAwsValue())
      )(_.webCrawlerConfiguration)
      .optionallyWith(
        workDocsConfiguration.map(value => value.buildAwsValue())
      )(_.workDocsConfiguration)
      .optionallyWith(fsxConfiguration.map(value => value.buildAwsValue()))(
        _.fsxConfiguration
      )
      .optionallyWith(slackConfiguration.map(value => value.buildAwsValue()))(
        _.slackConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceConfiguration.ReadOnly =
    zio.aws.kendra.model.DataSourceConfiguration.wrap(buildAwsValue())
}
object DataSourceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceConfiguration =
      zio.aws.kendra.model.DataSourceConfiguration(
        s3Configuration.map(value => value.asEditable),
        sharePointConfiguration.map(value => value.asEditable),
        databaseConfiguration.map(value => value.asEditable),
        salesforceConfiguration.map(value => value.asEditable),
        oneDriveConfiguration.map(value => value.asEditable),
        serviceNowConfiguration.map(value => value.asEditable),
        confluenceConfiguration.map(value => value.asEditable),
        googleDriveConfiguration.map(value => value.asEditable),
        webCrawlerConfiguration.map(value => value.asEditable),
        workDocsConfiguration.map(value => value.asEditable),
        fsxConfiguration.map(value => value.asEditable),
        slackConfiguration.map(value => value.asEditable)
      )
    def s3Configuration
        : Option[zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly]
    def sharePointConfiguration
        : Option[zio.aws.kendra.model.SharePointConfiguration.ReadOnly]
    def databaseConfiguration
        : Option[zio.aws.kendra.model.DatabaseConfiguration.ReadOnly]
    def salesforceConfiguration
        : Option[zio.aws.kendra.model.SalesforceConfiguration.ReadOnly]
    def oneDriveConfiguration
        : Option[zio.aws.kendra.model.OneDriveConfiguration.ReadOnly]
    def serviceNowConfiguration
        : Option[zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly]
    def confluenceConfiguration
        : Option[zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly]
    def googleDriveConfiguration
        : Option[zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly]
    def webCrawlerConfiguration
        : Option[zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly]
    def workDocsConfiguration
        : Option[zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly]
    def fsxConfiguration: Option[zio.aws.kendra.model.FsxConfiguration.ReadOnly]
    def slackConfiguration
        : Option[zio.aws.kendra.model.SlackConfiguration.ReadOnly]
    def getS3Configuration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("s3Configuration", s3Configuration)
    def getSharePointConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SharePointConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "sharePointConfiguration",
      sharePointConfiguration
    )
    def getDatabaseConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DatabaseConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("databaseConfiguration", databaseConfiguration)
    def getSalesforceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.SalesforceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "salesforceConfiguration",
      salesforceConfiguration
    )
    def getOneDriveConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.OneDriveConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("oneDriveConfiguration", oneDriveConfiguration)
    def getServiceNowConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serviceNowConfiguration",
      serviceNowConfiguration
    )
    def getConfluenceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "confluenceConfiguration",
      confluenceConfiguration
    )
    def getGoogleDriveConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "googleDriveConfiguration",
      googleDriveConfiguration
    )
    def getWebCrawlerConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "webCrawlerConfiguration",
      webCrawlerConfiguration
    )
    def getWorkDocsConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly
    ] =
      AwsError.unwrapOptionField("workDocsConfiguration", workDocsConfiguration)
    def getFsxConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.FsxConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("fsxConfiguration", fsxConfiguration)
    def getSlackConfiguration
        : ZIO[Any, AwsError, zio.aws.kendra.model.SlackConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("slackConfiguration", slackConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
  ) extends zio.aws.kendra.model.DataSourceConfiguration.ReadOnly {
    override val s3Configuration
        : Option[zio.aws.kendra.model.S3DataSourceConfiguration.ReadOnly] =
      scala
        .Option(impl.s3Configuration())
        .map(value =>
          zio.aws.kendra.model.S3DataSourceConfiguration.wrap(value)
        )
    override val sharePointConfiguration
        : Option[zio.aws.kendra.model.SharePointConfiguration.ReadOnly] = scala
      .Option(impl.sharePointConfiguration())
      .map(value => zio.aws.kendra.model.SharePointConfiguration.wrap(value))
    override val databaseConfiguration
        : Option[zio.aws.kendra.model.DatabaseConfiguration.ReadOnly] = scala
      .Option(impl.databaseConfiguration())
      .map(value => zio.aws.kendra.model.DatabaseConfiguration.wrap(value))
    override val salesforceConfiguration
        : Option[zio.aws.kendra.model.SalesforceConfiguration.ReadOnly] = scala
      .Option(impl.salesforceConfiguration())
      .map(value => zio.aws.kendra.model.SalesforceConfiguration.wrap(value))
    override val oneDriveConfiguration
        : Option[zio.aws.kendra.model.OneDriveConfiguration.ReadOnly] = scala
      .Option(impl.oneDriveConfiguration())
      .map(value => zio.aws.kendra.model.OneDriveConfiguration.wrap(value))
    override val serviceNowConfiguration
        : Option[zio.aws.kendra.model.ServiceNowConfiguration.ReadOnly] = scala
      .Option(impl.serviceNowConfiguration())
      .map(value => zio.aws.kendra.model.ServiceNowConfiguration.wrap(value))
    override val confluenceConfiguration
        : Option[zio.aws.kendra.model.ConfluenceConfiguration.ReadOnly] = scala
      .Option(impl.confluenceConfiguration())
      .map(value => zio.aws.kendra.model.ConfluenceConfiguration.wrap(value))
    override val googleDriveConfiguration
        : Option[zio.aws.kendra.model.GoogleDriveConfiguration.ReadOnly] = scala
      .Option(impl.googleDriveConfiguration())
      .map(value => zio.aws.kendra.model.GoogleDriveConfiguration.wrap(value))
    override val webCrawlerConfiguration
        : Option[zio.aws.kendra.model.WebCrawlerConfiguration.ReadOnly] = scala
      .Option(impl.webCrawlerConfiguration())
      .map(value => zio.aws.kendra.model.WebCrawlerConfiguration.wrap(value))
    override val workDocsConfiguration
        : Option[zio.aws.kendra.model.WorkDocsConfiguration.ReadOnly] = scala
      .Option(impl.workDocsConfiguration())
      .map(value => zio.aws.kendra.model.WorkDocsConfiguration.wrap(value))
    override val fsxConfiguration
        : Option[zio.aws.kendra.model.FsxConfiguration.ReadOnly] = scala
      .Option(impl.fsxConfiguration())
      .map(value => zio.aws.kendra.model.FsxConfiguration.wrap(value))
    override val slackConfiguration
        : Option[zio.aws.kendra.model.SlackConfiguration.ReadOnly] = scala
      .Option(impl.slackConfiguration())
      .map(value => zio.aws.kendra.model.SlackConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceConfiguration
  ): zio.aws.kendra.model.DataSourceConfiguration.ReadOnly = new Wrapper(impl)
}
