package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  LanguageCode,
  Timestamp,
  DataSourceId,
  DataSourceName
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DataSourceSummary(
    name: Option[DataSourceName] = None,
    id: Option[DataSourceId] = None,
    `type`: Option[zio.aws.kendra.model.DataSourceType] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    status: Option[zio.aws.kendra.model.DataSourceStatus] = None,
    languageCode: Option[LanguageCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceSummary = {
    import DataSourceSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceSummary
      .builder()
      .optionallyWith(
        name.map(value => DataSourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceSummary.ReadOnly =
    zio.aws.kendra.model.DataSourceSummary.wrap(buildAwsValue())
}
object DataSourceSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceSummary =
      zio.aws.kendra.model.DataSourceSummary(
        name.map(value => value),
        id.map(value => value),
        `type`.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        status.map(value => value),
        languageCode.map(value => value)
      )
    def name: Option[DataSourceName]
    def id: Option[DataSourceId]
    def `type`: Option[zio.aws.kendra.model.DataSourceType]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def status: Option[zio.aws.kendra.model.DataSourceStatus]
    def languageCode: Option[LanguageCode]
    def getName: ZIO[Any, AwsError, DataSourceName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSummary
  ) extends zio.aws.kendra.model.DataSourceSummary.ReadOnly {
    override val name: Option[DataSourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.DataSourceName(value))
    override val id: Option[DataSourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val `type`: Option[zio.aws.kendra.model.DataSourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.kendra.model.DataSourceType.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.kendra.model.DataSourceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.DataSourceStatus.wrap(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSummary
  ): zio.aws.kendra.model.DataSourceSummary.ReadOnly = new Wrapper(impl)
}
