package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.MetricValue
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DataSourceSyncJobMetrics(
    documentsAdded: Option[MetricValue] = None,
    documentsModified: Option[MetricValue] = None,
    documentsDeleted: Option[MetricValue] = None,
    documentsFailed: Option[MetricValue] = None,
    documentsScanned: Option[MetricValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetrics = {
    import DataSourceSyncJobMetrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetrics
      .builder()
      .optionallyWith(
        documentsAdded.map(value => MetricValue.unwrap(value): java.lang.String)
      )(_.documentsAdded)
      .optionallyWith(
        documentsModified.map(value =>
          MetricValue.unwrap(value): java.lang.String
        )
      )(_.documentsModified)
      .optionallyWith(
        documentsDeleted.map(value =>
          MetricValue.unwrap(value): java.lang.String
        )
      )(_.documentsDeleted)
      .optionallyWith(
        documentsFailed.map(value =>
          MetricValue.unwrap(value): java.lang.String
        )
      )(_.documentsFailed)
      .optionallyWith(
        documentsScanned.map(value =>
          MetricValue.unwrap(value): java.lang.String
        )
      )(_.documentsScanned)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DataSourceSyncJobMetrics.ReadOnly =
    zio.aws.kendra.model.DataSourceSyncJobMetrics.wrap(buildAwsValue())
}
object DataSourceSyncJobMetrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DataSourceSyncJobMetrics =
      zio.aws.kendra.model.DataSourceSyncJobMetrics(
        documentsAdded.map(value => value),
        documentsModified.map(value => value),
        documentsDeleted.map(value => value),
        documentsFailed.map(value => value),
        documentsScanned.map(value => value)
      )
    def documentsAdded: Option[MetricValue]
    def documentsModified: Option[MetricValue]
    def documentsDeleted: Option[MetricValue]
    def documentsFailed: Option[MetricValue]
    def documentsScanned: Option[MetricValue]
    def getDocumentsAdded: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("documentsAdded", documentsAdded)
    def getDocumentsModified: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("documentsModified", documentsModified)
    def getDocumentsDeleted: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("documentsDeleted", documentsDeleted)
    def getDocumentsFailed: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("documentsFailed", documentsFailed)
    def getDocumentsScanned: ZIO[Any, AwsError, MetricValue] =
      AwsError.unwrapOptionField("documentsScanned", documentsScanned)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetrics
  ) extends zio.aws.kendra.model.DataSourceSyncJobMetrics.ReadOnly {
    override val documentsAdded: Option[MetricValue] = scala
      .Option(impl.documentsAdded())
      .map(value => zio.aws.kendra.model.primitives.MetricValue(value))
    override val documentsModified: Option[MetricValue] = scala
      .Option(impl.documentsModified())
      .map(value => zio.aws.kendra.model.primitives.MetricValue(value))
    override val documentsDeleted: Option[MetricValue] = scala
      .Option(impl.documentsDeleted())
      .map(value => zio.aws.kendra.model.primitives.MetricValue(value))
    override val documentsFailed: Option[MetricValue] = scala
      .Option(impl.documentsFailed())
      .map(value => zio.aws.kendra.model.primitives.MetricValue(value))
    override val documentsScanned: Option[MetricValue] = scala
      .Option(impl.documentsScanned())
      .map(value => zio.aws.kendra.model.primitives.MetricValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DataSourceSyncJobMetrics
  ): zio.aws.kendra.model.DataSourceSyncJobMetrics.ReadOnly = new Wrapper(impl)
}
