package zio.aws.kendra.model
import scala.jdk.CollectionConverters._
sealed trait DatabaseEngineType {
  def unwrap: software.amazon.awssdk.services.kendra.model.DatabaseEngineType
}
object DatabaseEngineType {
  def wrap(
      value: software.amazon.awssdk.services.kendra.model.DatabaseEngineType
  ): zio.aws.kendra.model.DatabaseEngineType = value match {
    case software.amazon.awssdk.services.kendra.model.DatabaseEngineType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_AURORA_MYSQL =>
      val r = RDS_AURORA_MYSQL
      r
    case software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_AURORA_POSTGRESQL =>
      val r = RDS_AURORA_POSTGRESQL
      r
    case software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_MYSQL =>
      val r = RDS_MYSQL
      r
    case software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_POSTGRESQL =>
      val r = RDS_POSTGRESQL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.kendra.model.DatabaseEngineType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DatabaseEngineType =
      software.amazon.awssdk.services.kendra.model.DatabaseEngineType.UNKNOWN_TO_SDK_VERSION
  }
  case object RDS_AURORA_MYSQL extends zio.aws.kendra.model.DatabaseEngineType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DatabaseEngineType =
      software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_AURORA_MYSQL
  }
  case object RDS_AURORA_POSTGRESQL
      extends zio.aws.kendra.model.DatabaseEngineType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DatabaseEngineType =
      software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_AURORA_POSTGRESQL
  }
  case object RDS_MYSQL extends zio.aws.kendra.model.DatabaseEngineType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DatabaseEngineType =
      software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_MYSQL
  }
  case object RDS_POSTGRESQL extends zio.aws.kendra.model.DatabaseEngineType {
    override def unwrap
        : software.amazon.awssdk.services.kendra.model.DatabaseEngineType =
      software.amazon.awssdk.services.kendra.model.DatabaseEngineType.RDS_POSTGRESQL
  }
}
