package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  PrincipalOrderingId,
  GroupId,
  DataSourceId,
  IndexId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DeletePrincipalMappingRequest(
    indexId: IndexId,
    dataSourceId: Option[DataSourceId] = None,
    groupId: GroupId,
    orderingId: Option[PrincipalOrderingId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest = {
    import DeletePrincipalMappingRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .groupId(GroupId.unwrap(groupId): java.lang.String)
      .optionallyWith(
        orderingId.map(value =>
          PrincipalOrderingId.unwrap(value): java.lang.Long
        )
      )(_.orderingId)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DeletePrincipalMappingRequest.ReadOnly =
    zio.aws.kendra.model.DeletePrincipalMappingRequest.wrap(buildAwsValue())
}
object DeletePrincipalMappingRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DeletePrincipalMappingRequest =
      zio.aws.kendra.model.DeletePrincipalMappingRequest(
        indexId,
        dataSourceId.map(value => value),
        groupId,
        orderingId.map(value => value)
      )
    def indexId: IndexId
    def dataSourceId: Option[DataSourceId]
    def groupId: GroupId
    def orderingId: Option[PrincipalOrderingId]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getGroupId: ZIO[Any, Nothing, GroupId] = ZIO.succeed(groupId)
    def getOrderingId: ZIO[Any, AwsError, PrincipalOrderingId] =
      AwsError.unwrapOptionField("orderingId", orderingId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest
  ) extends zio.aws.kendra.model.DeletePrincipalMappingRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val dataSourceId: Option[DataSourceId] = scala
      .Option(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val groupId: GroupId =
      zio.aws.kendra.model.primitives.GroupId(impl.groupId())
    override val orderingId: Option[PrincipalOrderingId] = scala
      .Option(impl.orderingId())
      .map(value => zio.aws.kendra.model.primitives.PrincipalOrderingId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DeletePrincipalMappingRequest
  ): zio.aws.kendra.model.DeletePrincipalMappingRequest.ReadOnly = new Wrapper(
    impl
  )
}
