package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  DataSourceName,
  DataSourceId,
  LanguageCode,
  Timestamp,
  IndexId,
  Description,
  ScanSchedule
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeDataSourceResponse(
    id: Option[DataSourceId] = None,
    indexId: Option[IndexId] = None,
    name: Option[DataSourceName] = None,
    `type`: Option[zio.aws.kendra.model.DataSourceType] = None,
    configuration: Option[zio.aws.kendra.model.DataSourceConfiguration] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    description: Option[Description] = None,
    status: Option[zio.aws.kendra.model.DataSourceStatus] = None,
    schedule: Option[ScanSchedule] = None,
    roleArn: Option[RoleArn] = None,
    errorMessage: Option[ErrorMessage] = None,
    languageCode: Option[LanguageCode] = None,
    customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse = {
    import DescribeDataSourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
      .builder()
      .optionallyWith(
        id.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => DataSourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        schedule.map(value => ScanSchedule.unwrap(value): java.lang.String)
      )(_.schedule)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .optionallyWith(
        customDocumentEnrichmentConfiguration.map(value =>
          value.buildAwsValue()
        )
      )(_.customDocumentEnrichmentConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly =
    zio.aws.kendra.model.DescribeDataSourceResponse.wrap(buildAwsValue())
}
object DescribeDataSourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeDataSourceResponse =
      zio.aws.kendra.model.DescribeDataSourceResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        `type`.map(value => value),
        configuration.map(value => value.asEditable),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        description.map(value => value),
        status.map(value => value),
        schedule.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value),
        languageCode.map(value => value),
        customDocumentEnrichmentConfiguration.map(value => value.asEditable)
      )
    def id: Option[DataSourceId]
    def indexId: Option[IndexId]
    def name: Option[DataSourceName]
    def `type`: Option[zio.aws.kendra.model.DataSourceType]
    def configuration
        : Option[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def description: Option[Description]
    def status: Option[zio.aws.kendra.model.DataSourceStatus]
    def schedule: Option[ScanSchedule]
    def roleArn: Option[RoleArn]
    def errorMessage: Option[ErrorMessage]
    def languageCode: Option[LanguageCode]
    def customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ]
    def getId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, DataSourceName] =
      AwsError.unwrapOptionField("name", name)
    def getType: ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceType] =
      AwsError.unwrapOptionField("type", `type`)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DataSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.DataSourceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getSchedule: ZIO[Any, AwsError, ScanSchedule] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
    def getCustomDocumentEnrichmentConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customDocumentEnrichmentConfiguration",
      customDocumentEnrichmentConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
  ) extends zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly {
    override val id: Option[DataSourceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val indexId: Option[IndexId] = scala
      .Option(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Option[DataSourceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.DataSourceName(value))
    override val `type`: Option[zio.aws.kendra.model.DataSourceType] = scala
      .Option(impl.`type`())
      .map(value => zio.aws.kendra.model.DataSourceType.wrap(value))
    override val configuration
        : Option[zio.aws.kendra.model.DataSourceConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.kendra.model.DataSourceConfiguration.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status: Option[zio.aws.kendra.model.DataSourceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.DataSourceStatus.wrap(value))
    override val schedule: Option[ScanSchedule] = scala
      .Option(impl.schedule())
      .map(value => zio.aws.kendra.model.primitives.ScanSchedule(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
    override val customDocumentEnrichmentConfiguration: Option[
      zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.ReadOnly
    ] = scala
      .Option(impl.customDocumentEnrichmentConfiguration())
      .map(value =>
        zio.aws.kendra.model.CustomDocumentEnrichmentConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeDataSourceResponse
  ): zio.aws.kendra.model.DescribeDataSourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
