package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ExperienceName,
  ExperienceId,
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeExperienceResponse(
    id: Option[ExperienceId] = None,
    indexId: Option[IndexId] = None,
    name: Option[ExperienceName] = None,
    endpoints: Option[Iterable[zio.aws.kendra.model.ExperienceEndpoint]] = None,
    configuration: Option[zio.aws.kendra.model.ExperienceConfiguration] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    description: Option[Description] = None,
    status: Option[zio.aws.kendra.model.ExperienceStatus] = None,
    roleArn: Option[RoleArn] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse = {
    import DescribeExperienceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
      .builder()
      .optionallyWith(
        id.map(value => ExperienceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => ExperienceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .optionallyWith(configuration.map(value => value.buildAwsValue()))(
        _.configuration
      )
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly =
    zio.aws.kendra.model.DescribeExperienceResponse.wrap(buildAwsValue())
}
object DescribeExperienceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeExperienceResponse =
      zio.aws.kendra.model.DescribeExperienceResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        configuration.map(value => value.asEditable),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        description.map(value => value),
        status.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value)
      )
    def id: Option[ExperienceId]
    def indexId: Option[IndexId]
    def name: Option[ExperienceName]
    def endpoints
        : Option[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]]
    def configuration
        : Option[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def description: Option[Description]
    def status: Option[zio.aws.kendra.model.ExperienceStatus]
    def roleArn: Option[RoleArn]
    def errorMessage: Option[ErrorMessage]
    def getId: ZIO[Any, AwsError, ExperienceId] =
      AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, ExperienceName] =
      AwsError.unwrapOptionField("name", name)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExperienceEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
    def getConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ExperienceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("configuration", configuration)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ExperienceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
  ) extends zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly {
    override val id: Option[ExperienceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ExperienceId(value))
    override val indexId: Option[IndexId] = scala
      .Option(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Option[ExperienceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ExperienceName(value))
    override val endpoints
        : Option[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ExperienceEndpoint.wrap(item)
        }.toList
      )
    override val configuration
        : Option[zio.aws.kendra.model.ExperienceConfiguration.ReadOnly] = scala
      .Option(impl.configuration())
      .map(value => zio.aws.kendra.model.ExperienceConfiguration.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status: Option[zio.aws.kendra.model.ExperienceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.ExperienceStatus.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeExperienceResponse
  ): zio.aws.kendra.model.DescribeExperienceResponse.ReadOnly = new Wrapper(
    impl
  )
}
