package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  FaqId,
  LanguageCode,
  FaqName,
  Timestamp,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeFaqResponse(
    id: Option[FaqId] = None,
    indexId: Option[IndexId] = None,
    name: Option[FaqName] = None,
    description: Option[Description] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    s3Path: Option[zio.aws.kendra.model.S3Path] = None,
    status: Option[zio.aws.kendra.model.FaqStatus] = None,
    roleArn: Option[RoleArn] = None,
    errorMessage: Option[ErrorMessage] = None,
    fileFormat: Option[zio.aws.kendra.model.FaqFileFormat] = None,
    languageCode: Option[LanguageCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeFaqResponse = {
    import DescribeFaqResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
      .builder()
      .optionallyWith(id.map(value => FaqId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => FaqName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(s3Path.map(value => value.buildAwsValue()))(_.s3Path)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeFaqResponse.ReadOnly =
    zio.aws.kendra.model.DescribeFaqResponse.wrap(buildAwsValue())
}
object DescribeFaqResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeFaqResponse =
      zio.aws.kendra.model.DescribeFaqResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        s3Path.map(value => value.asEditable),
        status.map(value => value),
        roleArn.map(value => value),
        errorMessage.map(value => value),
        fileFormat.map(value => value),
        languageCode.map(value => value)
      )
    def id: Option[FaqId]
    def indexId: Option[IndexId]
    def name: Option[FaqName]
    def description: Option[Description]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def s3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def status: Option[zio.aws.kendra.model.FaqStatus]
    def roleArn: Option[RoleArn]
    def errorMessage: Option[ErrorMessage]
    def fileFormat: Option[zio.aws.kendra.model.FaqFileFormat]
    def languageCode: Option[LanguageCode]
    def getId: ZIO[Any, AwsError, FaqId] = AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, FaqName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getS3Path: ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("s3Path", s3Path)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.FaqStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getFileFormat: ZIO[Any, AwsError, zio.aws.kendra.model.FaqFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
  ) extends zio.aws.kendra.model.DescribeFaqResponse.ReadOnly {
    override val id: Option[FaqId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.FaqId(value))
    override val indexId: Option[IndexId] = scala
      .Option(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Option[FaqName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.FaqName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val s3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly] = scala
      .Option(impl.s3Path())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val status: Option[zio.aws.kendra.model.FaqStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.FaqStatus.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val fileFormat: Option[zio.aws.kendra.model.FaqFileFormat] = scala
      .Option(impl.fileFormat())
      .map(value => zio.aws.kendra.model.FaqFileFormat.wrap(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeFaqResponse
  ): zio.aws.kendra.model.DescribeFaqResponse.ReadOnly = new Wrapper(impl)
}
