package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  IndexName,
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeIndexResponse(
    name: Option[IndexName] = None,
    id: Option[IndexId] = None,
    edition: Option[zio.aws.kendra.model.IndexEdition] = None,
    roleArn: Option[RoleArn] = None,
    serverSideEncryptionConfiguration: Option[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration
    ] = None,
    status: Option[zio.aws.kendra.model.IndexStatus] = None,
    description: Option[Description] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    documentMetadataConfigurations: Option[
      Iterable[zio.aws.kendra.model.DocumentMetadataConfiguration]
    ] = None,
    indexStatistics: Option[zio.aws.kendra.model.IndexStatistics] = None,
    errorMessage: Option[ErrorMessage] = None,
    capacityUnits: Option[zio.aws.kendra.model.CapacityUnitsConfiguration] =
      None,
    userTokenConfigurations: Option[
      Iterable[zio.aws.kendra.model.UserTokenConfiguration]
    ] = None,
    userContextPolicy: Option[zio.aws.kendra.model.UserContextPolicy] = None,
    userGroupResolutionConfiguration: Option[
      zio.aws.kendra.model.UserGroupResolutionConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeIndexResponse = {
    import DescribeIndexResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
      .builder()
      .optionallyWith(
        name.map(value => IndexName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => IndexId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(edition.map(value => value.unwrap))(_.edition)
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(
        serverSideEncryptionConfiguration.map(value => value.buildAwsValue())
      )(_.serverSideEncryptionConfiguration)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        documentMetadataConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentMetadataConfigurations)
      .optionallyWith(indexStatistics.map(value => value.buildAwsValue()))(
        _.indexStatistics
      )
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(capacityUnits.map(value => value.buildAwsValue()))(
        _.capacityUnits
      )
      .optionallyWith(
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userTokenConfigurations)
      .optionallyWith(userContextPolicy.map(value => value.unwrap))(
        _.userContextPolicy
      )
      .optionallyWith(
        userGroupResolutionConfiguration.map(value => value.buildAwsValue())
      )(_.userGroupResolutionConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeIndexResponse.ReadOnly =
    zio.aws.kendra.model.DescribeIndexResponse.wrap(buildAwsValue())
}
object DescribeIndexResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeIndexResponse =
      zio.aws.kendra.model.DescribeIndexResponse(
        name.map(value => value),
        id.map(value => value),
        edition.map(value => value),
        roleArn.map(value => value),
        serverSideEncryptionConfiguration.map(value => value.asEditable),
        status.map(value => value),
        description.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        documentMetadataConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        indexStatistics.map(value => value.asEditable),
        errorMessage.map(value => value),
        capacityUnits.map(value => value.asEditable),
        userTokenConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        userContextPolicy.map(value => value),
        userGroupResolutionConfiguration.map(value => value.asEditable)
      )
    def name: Option[IndexName]
    def id: Option[IndexId]
    def edition: Option[zio.aws.kendra.model.IndexEdition]
    def roleArn: Option[RoleArn]
    def serverSideEncryptionConfiguration: Option[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ]
    def status: Option[zio.aws.kendra.model.IndexStatus]
    def description: Option[Description]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def documentMetadataConfigurations: Option[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ]
    def indexStatistics: Option[zio.aws.kendra.model.IndexStatistics.ReadOnly]
    def errorMessage: Option[ErrorMessage]
    def capacityUnits
        : Option[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly]
    def userTokenConfigurations
        : Option[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]]
    def userContextPolicy: Option[zio.aws.kendra.model.UserContextPolicy]
    def userGroupResolutionConfiguration
        : Option[zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly]
    def getName: ZIO[Any, AwsError, IndexName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("id", id)
    def getEdition: ZIO[Any, AwsError, zio.aws.kendra.model.IndexEdition] =
      AwsError.unwrapOptionField("edition", edition)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getServerSideEncryptionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "serverSideEncryptionConfiguration",
      serverSideEncryptionConfiguration
    )
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.IndexStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getDocumentMetadataConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "documentMetadataConfigurations",
      documentMetadataConfigurations
    )
    def getIndexStatistics
        : ZIO[Any, AwsError, zio.aws.kendra.model.IndexStatistics.ReadOnly] =
      AwsError.unwrapOptionField("indexStatistics", indexStatistics)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCapacityUnits: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField("capacityUnits", capacityUnits)
    def getUserTokenConfigurations: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.UserTokenConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "userTokenConfigurations",
      userTokenConfigurations
    )
    def getUserContextPolicy
        : ZIO[Any, AwsError, zio.aws.kendra.model.UserContextPolicy] =
      AwsError.unwrapOptionField("userContextPolicy", userContextPolicy)
    def getUserGroupResolutionConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userGroupResolutionConfiguration",
      userGroupResolutionConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
  ) extends zio.aws.kendra.model.DescribeIndexResponse.ReadOnly {
    override val name: Option[IndexName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.IndexName(value))
    override val id: Option[IndexId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val edition: Option[zio.aws.kendra.model.IndexEdition] = scala
      .Option(impl.edition())
      .map(value => zio.aws.kendra.model.IndexEdition.wrap(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val serverSideEncryptionConfiguration: Option[
      zio.aws.kendra.model.ServerSideEncryptionConfiguration.ReadOnly
    ] = scala
      .Option(impl.serverSideEncryptionConfiguration())
      .map(value =>
        zio.aws.kendra.model.ServerSideEncryptionConfiguration.wrap(value)
      )
    override val status: Option[zio.aws.kendra.model.IndexStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.IndexStatus.wrap(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val documentMetadataConfigurations: Option[
      List[zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly]
    ] = scala
      .Option(impl.documentMetadataConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentMetadataConfiguration.wrap(item)
        }.toList
      )
    override val indexStatistics
        : Option[zio.aws.kendra.model.IndexStatistics.ReadOnly] = scala
      .Option(impl.indexStatistics())
      .map(value => zio.aws.kendra.model.IndexStatistics.wrap(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val capacityUnits
        : Option[zio.aws.kendra.model.CapacityUnitsConfiguration.ReadOnly] =
      scala
        .Option(impl.capacityUnits())
        .map(value =>
          zio.aws.kendra.model.CapacityUnitsConfiguration.wrap(value)
        )
    override val userTokenConfigurations
        : Option[List[zio.aws.kendra.model.UserTokenConfiguration.ReadOnly]] =
      scala
        .Option(impl.userTokenConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.UserTokenConfiguration.wrap(item)
          }.toList
        )
    override val userContextPolicy
        : Option[zio.aws.kendra.model.UserContextPolicy] = scala
      .Option(impl.userContextPolicy())
      .map(value => zio.aws.kendra.model.UserContextPolicy.wrap(value))
    override val userGroupResolutionConfiguration: Option[
      zio.aws.kendra.model.UserGroupResolutionConfiguration.ReadOnly
    ] = scala
      .Option(impl.userGroupResolutionConfiguration())
      .map(value =>
        zio.aws.kendra.model.UserGroupResolutionConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeIndexResponse
  ): zio.aws.kendra.model.DescribeIndexResponse.ReadOnly = new Wrapper(impl)
}
