package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{GroupId, DataSourceId, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribePrincipalMappingResponse(
    indexId: Option[IndexId] = None,
    dataSourceId: Option[DataSourceId] = None,
    groupId: Option[GroupId] = None,
    groupOrderingIdSummaries: Option[
      Iterable[zio.aws.kendra.model.GroupOrderingIdSummary]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse = {
    import DescribePrincipalMappingResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse
      .builder()
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        dataSourceId.map(value => DataSourceId.unwrap(value): java.lang.String)
      )(_.dataSourceId)
      .optionallyWith(
        groupId.map(value => GroupId.unwrap(value): java.lang.String)
      )(_.groupId)
      .optionallyWith(
        groupOrderingIdSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.groupOrderingIdSummaries)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly =
    zio.aws.kendra.model.DescribePrincipalMappingResponse.wrap(buildAwsValue())
}
object DescribePrincipalMappingResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribePrincipalMappingResponse =
      zio.aws.kendra.model.DescribePrincipalMappingResponse(
        indexId.map(value => value),
        dataSourceId.map(value => value),
        groupId.map(value => value),
        groupOrderingIdSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def indexId: Option[IndexId]
    def dataSourceId: Option[DataSourceId]
    def groupId: Option[GroupId]
    def groupOrderingIdSummaries
        : Option[List[zio.aws.kendra.model.GroupOrderingIdSummary.ReadOnly]]
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getDataSourceId: ZIO[Any, AwsError, DataSourceId] =
      AwsError.unwrapOptionField("dataSourceId", dataSourceId)
    def getGroupId: ZIO[Any, AwsError, GroupId] =
      AwsError.unwrapOptionField("groupId", groupId)
    def getGroupOrderingIdSummaries: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.GroupOrderingIdSummary.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "groupOrderingIdSummaries",
      groupOrderingIdSummaries
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse
  ) extends zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly {
    override val indexId: Option[IndexId] = scala
      .Option(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val dataSourceId: Option[DataSourceId] = scala
      .Option(impl.dataSourceId())
      .map(value => zio.aws.kendra.model.primitives.DataSourceId(value))
    override val groupId: Option[GroupId] = scala
      .Option(impl.groupId())
      .map(value => zio.aws.kendra.model.primitives.GroupId(value))
    override val groupOrderingIdSummaries
        : Option[List[zio.aws.kendra.model.GroupOrderingIdSummary.ReadOnly]] =
      scala
        .Option(impl.groupOrderingIdSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.GroupOrderingIdSummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribePrincipalMappingResponse
  ): zio.aws.kendra.model.DescribePrincipalMappingResponse.ReadOnly =
    new Wrapper(impl)
}
