package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Integer,
  Description,
  QuerySuggestionsBlockListName,
  QuerySuggestionsBlockListId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeQuerySuggestionsBlockListResponse(
    indexId: Option[IndexId] = None,
    id: Option[QuerySuggestionsBlockListId] = None,
    name: Option[QuerySuggestionsBlockListName] = None,
    description: Option[Description] = None,
    status: Option[zio.aws.kendra.model.QuerySuggestionsBlockListStatus] = None,
    errorMessage: Option[ErrorMessage] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    sourceS3Path: Option[zio.aws.kendra.model.S3Path] = None,
    itemCount: Option[Integer] = None,
    fileSizeBytes: Option[Long] = None,
    roleArn: Option[RoleArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse = {
    import DescribeQuerySuggestionsBlockListResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse
      .builder()
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        id.map(value =>
          QuerySuggestionsBlockListId.unwrap(value): java.lang.String
        )
      )(_.id)
      .optionallyWith(
        name.map(value =>
          QuerySuggestionsBlockListName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(sourceS3Path.map(value => value.buildAwsValue()))(
        _.sourceS3Path
      )
      .optionallyWith(itemCount.map(value => value: java.lang.Integer))(
        _.itemCount
      )
      .optionallyWith(fileSizeBytes.map(value => value: java.lang.Long))(
        _.fileSizeBytes
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly =
    zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse
      .wrap(buildAwsValue())
}
object DescribeQuerySuggestionsBlockListResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse =
      zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse(
        indexId.map(value => value),
        id.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        errorMessage.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        sourceS3Path.map(value => value.asEditable),
        itemCount.map(value => value),
        fileSizeBytes.map(value => value),
        roleArn.map(value => value)
      )
    def indexId: Option[IndexId]
    def id: Option[QuerySuggestionsBlockListId]
    def name: Option[QuerySuggestionsBlockListName]
    def description: Option[Description]
    def status: Option[zio.aws.kendra.model.QuerySuggestionsBlockListStatus]
    def errorMessage: Option[ErrorMessage]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def itemCount: Option[Integer]
    def fileSizeBytes: Option[Long]
    def roleArn: Option[RoleArn]
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getId: ZIO[Any, AwsError, QuerySuggestionsBlockListId] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, QuerySuggestionsBlockListName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.QuerySuggestionsBlockListStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getSourceS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Path", sourceS3Path)
    def getItemCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("itemCount", itemCount)
    def getFileSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fileSizeBytes", fileSizeBytes)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse
  ) extends zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly {
    override val indexId: Option[IndexId] = scala
      .Option(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val id: Option[QuerySuggestionsBlockListId] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.kendra.model.primitives.QuerySuggestionsBlockListId(value)
      )
    override val name: Option[QuerySuggestionsBlockListName] = scala
      .Option(impl.name())
      .map(value =>
        zio.aws.kendra.model.primitives.QuerySuggestionsBlockListName(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status
        : Option[zio.aws.kendra.model.QuerySuggestionsBlockListStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.kendra.model.QuerySuggestionsBlockListStatus.wrap(value)
      )
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly] =
      scala
        .Option(impl.sourceS3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val itemCount: Option[Integer] =
      scala.Option(impl.itemCount()).map(value => value: Integer)
    override val fileSizeBytes: Option[Long] =
      scala.Option(impl.fileSizeBytes()).map(value => value: Long)
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsBlockListResponse
  ): zio.aws.kendra.model.DescribeQuerySuggestionsBlockListResponse.ReadOnly =
    new Wrapper(impl)
}
