package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  MinimumQueryCount,
  ObjectBoolean,
  Timestamp,
  MinimumNumberOfQueryingUsers,
  Integer
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeQuerySuggestionsConfigResponse(
    mode: Option[zio.aws.kendra.model.Mode] = None,
    status: Option[zio.aws.kendra.model.QuerySuggestionsStatus] = None,
    queryLogLookBackWindowInDays: Option[Integer] = None,
    includeQueriesWithoutUserInformation: Option[ObjectBoolean] = None,
    minimumNumberOfQueryingUsers: Option[MinimumNumberOfQueryingUsers] = None,
    minimumQueryCount: Option[MinimumQueryCount] = None,
    lastSuggestionsBuildTime: Option[Timestamp] = None,
    lastClearTime: Option[Timestamp] = None,
    totalSuggestionsCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse = {
    import DescribeQuerySuggestionsConfigResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
      .builder()
      .optionallyWith(mode.map(value => value.unwrap))(_.mode)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        queryLogLookBackWindowInDays.map(value => value: java.lang.Integer)
      )(_.queryLogLookBackWindowInDays)
      .optionallyWith(
        includeQueriesWithoutUserInformation.map(value =>
          ObjectBoolean.unwrap(value): java.lang.Boolean
        )
      )(_.includeQueriesWithoutUserInformation)
      .optionallyWith(
        minimumNumberOfQueryingUsers.map(value =>
          MinimumNumberOfQueryingUsers.unwrap(value): java.lang.Integer
        )
      )(_.minimumNumberOfQueryingUsers)
      .optionallyWith(
        minimumQueryCount.map(value =>
          MinimumQueryCount.unwrap(value): java.lang.Integer
        )
      )(_.minimumQueryCount)
      .optionallyWith(
        lastSuggestionsBuildTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastSuggestionsBuildTime)
      .optionallyWith(
        lastClearTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastClearTime)
      .optionallyWith(
        totalSuggestionsCount.map(value => value: java.lang.Integer)
      )(_.totalSuggestionsCount)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly =
    zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse
      .wrap(buildAwsValue())
}
object DescribeQuerySuggestionsConfigResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse =
      zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse(
        mode.map(value => value),
        status.map(value => value),
        queryLogLookBackWindowInDays.map(value => value),
        includeQueriesWithoutUserInformation.map(value => value),
        minimumNumberOfQueryingUsers.map(value => value),
        minimumQueryCount.map(value => value),
        lastSuggestionsBuildTime.map(value => value),
        lastClearTime.map(value => value),
        totalSuggestionsCount.map(value => value)
      )
    def mode: Option[zio.aws.kendra.model.Mode]
    def status: Option[zio.aws.kendra.model.QuerySuggestionsStatus]
    def queryLogLookBackWindowInDays: Option[Integer]
    def includeQueriesWithoutUserInformation: Option[ObjectBoolean]
    def minimumNumberOfQueryingUsers: Option[MinimumNumberOfQueryingUsers]
    def minimumQueryCount: Option[MinimumQueryCount]
    def lastSuggestionsBuildTime: Option[Timestamp]
    def lastClearTime: Option[Timestamp]
    def totalSuggestionsCount: Option[Integer]
    def getMode: ZIO[Any, AwsError, zio.aws.kendra.model.Mode] =
      AwsError.unwrapOptionField("mode", mode)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.kendra.model.QuerySuggestionsStatus] =
      AwsError.unwrapOptionField("status", status)
    def getQueryLogLookBackWindowInDays: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField(
        "queryLogLookBackWindowInDays",
        queryLogLookBackWindowInDays
      )
    def getIncludeQueriesWithoutUserInformation
        : ZIO[Any, AwsError, ObjectBoolean] = AwsError.unwrapOptionField(
      "includeQueriesWithoutUserInformation",
      includeQueriesWithoutUserInformation
    )
    def getMinimumNumberOfQueryingUsers
        : ZIO[Any, AwsError, MinimumNumberOfQueryingUsers] =
      AwsError.unwrapOptionField(
        "minimumNumberOfQueryingUsers",
        minimumNumberOfQueryingUsers
      )
    def getMinimumQueryCount: ZIO[Any, AwsError, MinimumQueryCount] =
      AwsError.unwrapOptionField("minimumQueryCount", minimumQueryCount)
    def getLastSuggestionsBuildTime: ZIO[Any, AwsError, Timestamp] = AwsError
      .unwrapOptionField("lastSuggestionsBuildTime", lastSuggestionsBuildTime)
    def getLastClearTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastClearTime", lastClearTime)
    def getTotalSuggestionsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("totalSuggestionsCount", totalSuggestionsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
  ) extends zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly {
    override val mode: Option[zio.aws.kendra.model.Mode] = scala
      .Option(impl.mode())
      .map(value => zio.aws.kendra.model.Mode.wrap(value))
    override val status: Option[zio.aws.kendra.model.QuerySuggestionsStatus] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.kendra.model.QuerySuggestionsStatus.wrap(value))
    override val queryLogLookBackWindowInDays: Option[Integer] = scala
      .Option(impl.queryLogLookBackWindowInDays())
      .map(value => value: Integer)
    override val includeQueriesWithoutUserInformation: Option[ObjectBoolean] =
      scala
        .Option(impl.includeQueriesWithoutUserInformation())
        .map(value => zio.aws.kendra.model.primitives.ObjectBoolean(value))
    override val minimumNumberOfQueryingUsers
        : Option[MinimumNumberOfQueryingUsers] = scala
      .Option(impl.minimumNumberOfQueryingUsers())
      .map(value =>
        zio.aws.kendra.model.primitives.MinimumNumberOfQueryingUsers(value)
      )
    override val minimumQueryCount: Option[MinimumQueryCount] = scala
      .Option(impl.minimumQueryCount())
      .map(value => zio.aws.kendra.model.primitives.MinimumQueryCount(value))
    override val lastSuggestionsBuildTime: Option[Timestamp] = scala
      .Option(impl.lastSuggestionsBuildTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val lastClearTime: Option[Timestamp] = scala
      .Option(impl.lastClearTime())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val totalSuggestionsCount: Option[Integer] =
      scala.Option(impl.totalSuggestionsCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeQuerySuggestionsConfigResponse
  ): zio.aws.kendra.model.DescribeQuerySuggestionsConfigResponse.ReadOnly =
    new Wrapper(impl)
}
