package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{
  ErrorMessage,
  RoleArn,
  Timestamp,
  IndexId,
  Description,
  ThesaurusName,
  ThesaurusId
}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class DescribeThesaurusResponse(
    id: Option[ThesaurusId] = None,
    indexId: Option[IndexId] = None,
    name: Option[ThesaurusName] = None,
    description: Option[Description] = None,
    status: Option[zio.aws.kendra.model.ThesaurusStatus] = None,
    errorMessage: Option[ErrorMessage] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    roleArn: Option[RoleArn] = None,
    sourceS3Path: Option[zio.aws.kendra.model.S3Path] = None,
    fileSizeBytes: Option[Long] = None,
    termCount: Option[Long] = None,
    synonymRuleCount: Option[Long] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse = {
    import DescribeThesaurusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
      .builder()
      .optionallyWith(
        id.map(value => ThesaurusId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        indexId.map(value => IndexId.unwrap(value): java.lang.String)
      )(_.indexId)
      .optionallyWith(
        name.map(value => ThesaurusName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(
        roleArn.map(value => RoleArn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(sourceS3Path.map(value => value.buildAwsValue()))(
        _.sourceS3Path
      )
      .optionallyWith(fileSizeBytes.map(value => value: java.lang.Long))(
        _.fileSizeBytes
      )
      .optionallyWith(termCount.map(value => value: java.lang.Long))(
        _.termCount
      )
      .optionallyWith(synonymRuleCount.map(value => value: java.lang.Long))(
        _.synonymRuleCount
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly =
    zio.aws.kendra.model.DescribeThesaurusResponse.wrap(buildAwsValue())
}
object DescribeThesaurusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DescribeThesaurusResponse =
      zio.aws.kendra.model.DescribeThesaurusResponse(
        id.map(value => value),
        indexId.map(value => value),
        name.map(value => value),
        description.map(value => value),
        status.map(value => value),
        errorMessage.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        roleArn.map(value => value),
        sourceS3Path.map(value => value.asEditable),
        fileSizeBytes.map(value => value),
        termCount.map(value => value),
        synonymRuleCount.map(value => value)
      )
    def id: Option[ThesaurusId]
    def indexId: Option[IndexId]
    def name: Option[ThesaurusName]
    def description: Option[Description]
    def status: Option[zio.aws.kendra.model.ThesaurusStatus]
    def errorMessage: Option[ErrorMessage]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def roleArn: Option[RoleArn]
    def sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def fileSizeBytes: Option[Long]
    def termCount: Option[Long]
    def synonymRuleCount: Option[Long]
    def getId: ZIO[Any, AwsError, ThesaurusId] =
      AwsError.unwrapOptionField("id", id)
    def getIndexId: ZIO[Any, AwsError, IndexId] =
      AwsError.unwrapOptionField("indexId", indexId)
    def getName: ZIO[Any, AwsError, ThesaurusName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ThesaurusStatus] =
      AwsError.unwrapOptionField("status", status)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getRoleArn: ZIO[Any, AwsError, RoleArn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getSourceS3Path
        : ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("sourceS3Path", sourceS3Path)
    def getFileSizeBytes: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("fileSizeBytes", fileSizeBytes)
    def getTermCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("termCount", termCount)
    def getSynonymRuleCount: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("synonymRuleCount", synonymRuleCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
  ) extends zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly {
    override val id: Option[ThesaurusId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusId(value))
    override val indexId: Option[IndexId] = scala
      .Option(impl.indexId())
      .map(value => zio.aws.kendra.model.primitives.IndexId(value))
    override val name: Option[ThesaurusName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ThesaurusName(value))
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value => zio.aws.kendra.model.primitives.Description(value))
    override val status: Option[zio.aws.kendra.model.ThesaurusStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.ThesaurusStatus.wrap(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val roleArn: Option[RoleArn] = scala
      .Option(impl.roleArn())
      .map(value => zio.aws.kendra.model.primitives.RoleArn(value))
    override val sourceS3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly] =
      scala
        .Option(impl.sourceS3Path())
        .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val fileSizeBytes: Option[Long] =
      scala.Option(impl.fileSizeBytes()).map(value => value: Long)
    override val termCount: Option[Long] =
      scala.Option(impl.termCount()).map(value => value: Long)
    override val synonymRuleCount: Option[Long] =
      scala.Option(impl.synonymRuleCount()).map(value => value: Long)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DescribeThesaurusResponse
  ): zio.aws.kendra.model.DescribeThesaurusResponse.ReadOnly = new Wrapper(impl)
}
