package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{EntityId, IndexId, ExperienceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DisassociatePersonasFromEntitiesRequest(
    id: ExperienceId,
    indexId: IndexId,
    entityIds: Iterable[EntityId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest = {
    import DisassociatePersonasFromEntitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest
      .builder()
      .id(ExperienceId.unwrap(id): java.lang.String)
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .entityIds(entityIds.map { item =>
        EntityId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest.ReadOnly =
    zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest
      .wrap(buildAwsValue())
}
object DisassociatePersonasFromEntitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest =
      zio.aws.kendra.model
        .DisassociatePersonasFromEntitiesRequest(id, indexId, entityIds)
    def id: ExperienceId
    def indexId: IndexId
    def entityIds: List[EntityId]
    def getId: ZIO[Any, Nothing, ExperienceId] = ZIO.succeed(id)
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getEntityIds: ZIO[Any, Nothing, List[EntityId]] = ZIO.succeed(entityIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest
  ) extends zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest.ReadOnly {
    override val id: ExperienceId =
      zio.aws.kendra.model.primitives.ExperienceId(impl.id())
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val entityIds: List[EntityId] = impl
      .entityIds()
      .asScala
      .map { item =>
        zio.aws.kendra.model.primitives.EntityId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DisassociatePersonasFromEntitiesRequest
  ): zio.aws.kendra.model.DisassociatePersonasFromEntitiesRequest.ReadOnly =
    new Wrapper(impl)
}
