package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Blob, Title, DocumentId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Document(
    id: DocumentId,
    title: Option[Title] = None,
    blob: Option[Blob] = None,
    s3Path: Option[zio.aws.kendra.model.S3Path] = None,
    attributes: Option[Iterable[zio.aws.kendra.model.DocumentAttribute]] = None,
    accessControlList: Option[Iterable[zio.aws.kendra.model.Principal]] = None,
    hierarchicalAccessControlList: Option[
      Iterable[zio.aws.kendra.model.HierarchicalPrincipal]
    ] = None,
    contentType: Option[zio.aws.kendra.model.ContentType] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Document = {
    import Document.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Document
      .builder()
      .id(DocumentId.unwrap(id): java.lang.String)
      .optionallyWith(
        title.map(value => Title.unwrap(value): java.lang.String)
      )(_.title)
      .optionallyWith(
        blob.map(value =>
          software.amazon.awssdk.core.SdkBytes.fromByteArrayUnsafe(
            value.toArray[Byte]
          )
        )
      )(_.blob)
      .optionallyWith(s3Path.map(value => value.buildAwsValue()))(_.s3Path)
      .optionallyWith(
        attributes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.attributes)
      .optionallyWith(
        accessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.accessControlList)
      .optionallyWith(
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.hierarchicalAccessControlList)
      .optionallyWith(contentType.map(value => value.unwrap))(_.contentType)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Document.ReadOnly =
    zio.aws.kendra.model.Document.wrap(buildAwsValue())
}
object Document {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Document] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Document =
      zio.aws.kendra.model.Document(
        id,
        title.map(value => value),
        blob.map(value => value),
        s3Path.map(value => value.asEditable),
        attributes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        accessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        hierarchicalAccessControlList.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        contentType.map(value => value)
      )
    def id: DocumentId
    def title: Option[Title]
    def blob: Option[Blob]
    def s3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly]
    def attributes
        : Option[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]]
    def accessControlList: Option[List[zio.aws.kendra.model.Principal.ReadOnly]]
    def hierarchicalAccessControlList
        : Option[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]]
    def contentType: Option[zio.aws.kendra.model.ContentType]
    def getId: ZIO[Any, Nothing, DocumentId] = ZIO.succeed(id)
    def getTitle: ZIO[Any, AwsError, Title] =
      AwsError.unwrapOptionField("title", title)
    def getBlob: ZIO[Any, AwsError, Blob] =
      AwsError.unwrapOptionField("blob", blob)
    def getS3Path: ZIO[Any, AwsError, zio.aws.kendra.model.S3Path.ReadOnly] =
      AwsError.unwrapOptionField("s3Path", s3Path)
    def getAttributes: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.DocumentAttribute.ReadOnly
    ]] = AwsError.unwrapOptionField("attributes", attributes)
    def getAccessControlList
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Principal.ReadOnly]] =
      AwsError.unwrapOptionField("accessControlList", accessControlList)
    def getHierarchicalAccessControlList: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "hierarchicalAccessControlList",
      hierarchicalAccessControlList
    )
    def getContentType: ZIO[Any, AwsError, zio.aws.kendra.model.ContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Document
  ) extends zio.aws.kendra.model.Document.ReadOnly {
    override val id: DocumentId =
      zio.aws.kendra.model.primitives.DocumentId(impl.id())
    override val title: Option[Title] = scala
      .Option(impl.title())
      .map(value => zio.aws.kendra.model.primitives.Title(value))
    override val blob: Option[Blob] = scala
      .Option(impl.blob())
      .map(value =>
        zio.aws.kendra.model.primitives
          .Blob(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
      )
    override val s3Path: Option[zio.aws.kendra.model.S3Path.ReadOnly] = scala
      .Option(impl.s3Path())
      .map(value => zio.aws.kendra.model.S3Path.wrap(value))
    override val attributes
        : Option[List[zio.aws.kendra.model.DocumentAttribute.ReadOnly]] = scala
      .Option(impl.attributes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.DocumentAttribute.wrap(item)
        }.toList
      )
    override val accessControlList
        : Option[List[zio.aws.kendra.model.Principal.ReadOnly]] = scala
      .Option(impl.accessControlList())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Principal.wrap(item)
        }.toList
      )
    override val hierarchicalAccessControlList
        : Option[List[zio.aws.kendra.model.HierarchicalPrincipal.ReadOnly]] =
      scala
        .Option(impl.hierarchicalAccessControlList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.kendra.model.HierarchicalPrincipal.wrap(item)
          }.toList
        )
    override val contentType: Option[zio.aws.kendra.model.ContentType] = scala
      .Option(impl.contentType())
      .map(value => zio.aws.kendra.model.ContentType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Document
  ): zio.aws.kendra.model.Document.ReadOnly = new Wrapper(impl)
}
