package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentAttributeTarget(
    targetDocumentAttributeKey: Option[DocumentAttributeKey] = None,
    targetDocumentAttributeValueDeletion: Option[Boolean] = None,
    targetDocumentAttributeValue: Option[
      zio.aws.kendra.model.DocumentAttributeValue
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentAttributeTarget = {
    import DocumentAttributeTarget.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentAttributeTarget
      .builder()
      .optionallyWith(
        targetDocumentAttributeKey.map(value =>
          DocumentAttributeKey.unwrap(value): java.lang.String
        )
      )(_.targetDocumentAttributeKey)
      .optionallyWith(
        targetDocumentAttributeValueDeletion.map(value =>
          value: java.lang.Boolean
        )
      )(_.targetDocumentAttributeValueDeletion)
      .optionallyWith(
        targetDocumentAttributeValue.map(value => value.buildAwsValue())
      )(_.targetDocumentAttributeValue)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly =
    zio.aws.kendra.model.DocumentAttributeTarget.wrap(buildAwsValue())
}
object DocumentAttributeTarget {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentAttributeTarget
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentAttributeTarget =
      zio.aws.kendra.model.DocumentAttributeTarget(
        targetDocumentAttributeKey.map(value => value),
        targetDocumentAttributeValueDeletion.map(value => value),
        targetDocumentAttributeValue.map(value => value.asEditable)
      )
    def targetDocumentAttributeKey: Option[DocumentAttributeKey]
    def targetDocumentAttributeValueDeletion: Option[Boolean]
    def targetDocumentAttributeValue
        : Option[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly]
    def getTargetDocumentAttributeKey
        : ZIO[Any, AwsError, DocumentAttributeKey] = AwsError.unwrapOptionField(
      "targetDocumentAttributeKey",
      targetDocumentAttributeKey
    )
    def getTargetDocumentAttributeValueDeletion: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField(
        "targetDocumentAttributeValueDeletion",
        targetDocumentAttributeValueDeletion
      )
    def getTargetDocumentAttributeValue: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetDocumentAttributeValue",
      targetDocumentAttributeValue
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeTarget
  ) extends zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly {
    override val targetDocumentAttributeKey: Option[DocumentAttributeKey] =
      scala
        .Option(impl.targetDocumentAttributeKey())
        .map(value =>
          zio.aws.kendra.model.primitives.DocumentAttributeKey(value)
        )
    override val targetDocumentAttributeValueDeletion: Option[Boolean] = scala
      .Option(impl.targetDocumentAttributeValueDeletion())
      .map(value => value: Boolean)
    override val targetDocumentAttributeValue
        : Option[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly] = scala
      .Option(impl.targetDocumentAttributeValue())
      .map(value => zio.aws.kendra.model.DocumentAttributeValue.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeTarget
  ): zio.aws.kendra.model.DocumentAttributeTarget.ReadOnly = new Wrapper(impl)
}
