package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Integer
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentAttributeValueCountPair(
    documentAttributeValue: Option[
      zio.aws.kendra.model.DocumentAttributeValue
    ] = None,
    count: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair = {
    import DocumentAttributeValueCountPair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
      .builder()
      .optionallyWith(
        documentAttributeValue.map(value => value.buildAwsValue())
      )(_.documentAttributeValue)
      .optionallyWith(count.map(value => value: java.lang.Integer))(_.count)
      .build()
  }
  def asReadOnly
      : zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly =
    zio.aws.kendra.model.DocumentAttributeValueCountPair.wrap(buildAwsValue())
}
object DocumentAttributeValueCountPair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentAttributeValueCountPair =
      zio.aws.kendra.model.DocumentAttributeValueCountPair(
        documentAttributeValue.map(value => value.asEditable),
        count.map(value => value)
      )
    def documentAttributeValue
        : Option[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly]
    def count: Option[Integer]
    def getDocumentAttributeValue: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.DocumentAttributeValue.ReadOnly
    ] = AwsError.unwrapOptionField(
      "documentAttributeValue",
      documentAttributeValue
    )
    def getCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("count", count)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
  ) extends zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly {
    override val documentAttributeValue
        : Option[zio.aws.kendra.model.DocumentAttributeValue.ReadOnly] = scala
      .Option(impl.documentAttributeValue())
      .map(value => zio.aws.kendra.model.DocumentAttributeValue.wrap(value))
    override val count: Option[Integer] =
      scala.Option(impl.count()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentAttributeValueCountPair
  ): zio.aws.kendra.model.DocumentAttributeValueCountPair.ReadOnly =
    new Wrapper(impl)
}
