package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentMetadataConfigurationName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DocumentMetadataConfiguration(
    name: DocumentMetadataConfigurationName,
    `type`: zio.aws.kendra.model.DocumentAttributeValueType,
    relevance: Option[zio.aws.kendra.model.Relevance] = None,
    search: Option[zio.aws.kendra.model.Search] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration = {
    import DocumentMetadataConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration
      .builder()
      .name(DocumentMetadataConfigurationName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .optionallyWith(relevance.map(value => value.buildAwsValue()))(
        _.relevance
      )
      .optionallyWith(search.map(value => value.buildAwsValue()))(_.search)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly =
    zio.aws.kendra.model.DocumentMetadataConfiguration.wrap(buildAwsValue())
}
object DocumentMetadataConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.DocumentMetadataConfiguration =
      zio.aws.kendra.model.DocumentMetadataConfiguration(
        name,
        `type`,
        relevance.map(value => value.asEditable),
        search.map(value => value.asEditable)
      )
    def name: DocumentMetadataConfigurationName
    def `type`: zio.aws.kendra.model.DocumentAttributeValueType
    def relevance: Option[zio.aws.kendra.model.Relevance.ReadOnly]
    def search: Option[zio.aws.kendra.model.Search.ReadOnly]
    def getName: ZIO[Any, Nothing, DocumentMetadataConfigurationName] =
      ZIO.succeed(name)
    def getType
        : ZIO[Any, Nothing, zio.aws.kendra.model.DocumentAttributeValueType] =
      ZIO.succeed(`type`)
    def getRelevance
        : ZIO[Any, AwsError, zio.aws.kendra.model.Relevance.ReadOnly] =
      AwsError.unwrapOptionField("relevance", relevance)
    def getSearch: ZIO[Any, AwsError, zio.aws.kendra.model.Search.ReadOnly] =
      AwsError.unwrapOptionField("search", search)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration
  ) extends zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly {
    override val name: DocumentMetadataConfigurationName =
      zio.aws.kendra.model.primitives
        .DocumentMetadataConfigurationName(impl.name())
    override val `type`: zio.aws.kendra.model.DocumentAttributeValueType =
      zio.aws.kendra.model.DocumentAttributeValueType.wrap(impl.`type`())
    override val relevance: Option[zio.aws.kendra.model.Relevance.ReadOnly] =
      scala
        .Option(impl.relevance())
        .map(value => zio.aws.kendra.model.Relevance.wrap(value))
    override val search: Option[zio.aws.kendra.model.Search.ReadOnly] = scala
      .Option(impl.search())
      .map(value => zio.aws.kendra.model.Search.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.DocumentMetadataConfiguration
  ): zio.aws.kendra.model.DocumentMetadataConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
