package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.NameType
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class EntityDisplayData(
    userName: Option[NameType] = None,
    groupName: Option[NameType] = None,
    identifiedUserName: Option[NameType] = None,
    firstName: Option[NameType] = None,
    lastName: Option[NameType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.EntityDisplayData = {
    import EntityDisplayData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.EntityDisplayData
      .builder()
      .optionallyWith(
        userName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.userName)
      .optionallyWith(
        groupName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.groupName)
      .optionallyWith(
        identifiedUserName.map(value =>
          NameType.unwrap(value): java.lang.String
        )
      )(_.identifiedUserName)
      .optionallyWith(
        firstName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.firstName)
      .optionallyWith(
        lastName.map(value => NameType.unwrap(value): java.lang.String)
      )(_.lastName)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.EntityDisplayData.ReadOnly =
    zio.aws.kendra.model.EntityDisplayData.wrap(buildAwsValue())
}
object EntityDisplayData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.EntityDisplayData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.EntityDisplayData =
      zio.aws.kendra.model.EntityDisplayData(
        userName.map(value => value),
        groupName.map(value => value),
        identifiedUserName.map(value => value),
        firstName.map(value => value),
        lastName.map(value => value)
      )
    def userName: Option[NameType]
    def groupName: Option[NameType]
    def identifiedUserName: Option[NameType]
    def firstName: Option[NameType]
    def lastName: Option[NameType]
    def getUserName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("userName", userName)
    def getGroupName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("groupName", groupName)
    def getIdentifiedUserName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("identifiedUserName", identifiedUserName)
    def getFirstName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("firstName", firstName)
    def getLastName: ZIO[Any, AwsError, NameType] =
      AwsError.unwrapOptionField("lastName", lastName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.EntityDisplayData
  ) extends zio.aws.kendra.model.EntityDisplayData.ReadOnly {
    override val userName: Option[NameType] = scala
      .Option(impl.userName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val groupName: Option[NameType] = scala
      .Option(impl.groupName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val identifiedUserName: Option[NameType] = scala
      .Option(impl.identifiedUserName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val firstName: Option[NameType] = scala
      .Option(impl.firstName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
    override val lastName: Option[NameType] = scala
      .Option(impl.lastName())
      .map(value => zio.aws.kendra.model.primitives.NameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.EntityDisplayData
  ): zio.aws.kendra.model.EntityDisplayData.ReadOnly = new Wrapper(impl)
}
