package zio.aws.kendra.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExperienceConfiguration(
    contentSourceConfiguration: Option[
      zio.aws.kendra.model.ContentSourceConfiguration
    ] = None,
    userIdentityConfiguration: Option[
      zio.aws.kendra.model.UserIdentityConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExperienceConfiguration = {
    import ExperienceConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExperienceConfiguration
      .builder()
      .optionallyWith(
        contentSourceConfiguration.map(value => value.buildAwsValue())
      )(_.contentSourceConfiguration)
      .optionallyWith(
        userIdentityConfiguration.map(value => value.buildAwsValue())
      )(_.userIdentityConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExperienceConfiguration.ReadOnly =
    zio.aws.kendra.model.ExperienceConfiguration.wrap(buildAwsValue())
}
object ExperienceConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExperienceConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExperienceConfiguration =
      zio.aws.kendra.model.ExperienceConfiguration(
        contentSourceConfiguration.map(value => value.asEditable),
        userIdentityConfiguration.map(value => value.asEditable)
      )
    def contentSourceConfiguration
        : Option[zio.aws.kendra.model.ContentSourceConfiguration.ReadOnly]
    def userIdentityConfiguration
        : Option[zio.aws.kendra.model.UserIdentityConfiguration.ReadOnly]
    def getContentSourceConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.ContentSourceConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "contentSourceConfiguration",
      contentSourceConfiguration
    )
    def getUserIdentityConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.kendra.model.UserIdentityConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "userIdentityConfiguration",
      userIdentityConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExperienceConfiguration
  ) extends zio.aws.kendra.model.ExperienceConfiguration.ReadOnly {
    override val contentSourceConfiguration
        : Option[zio.aws.kendra.model.ContentSourceConfiguration.ReadOnly] =
      scala
        .Option(impl.contentSourceConfiguration())
        .map(value =>
          zio.aws.kendra.model.ContentSourceConfiguration.wrap(value)
        )
    override val userIdentityConfiguration
        : Option[zio.aws.kendra.model.UserIdentityConfiguration.ReadOnly] =
      scala
        .Option(impl.userIdentityConfiguration())
        .map(value =>
          zio.aws.kendra.model.UserIdentityConfiguration.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExperienceConfiguration
  ): zio.aws.kendra.model.ExperienceConfiguration.ReadOnly = new Wrapper(impl)
}
