package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.Endpoint
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExperienceEndpoint(
    endpointType: Option[zio.aws.kendra.model.EndpointType] = None,
    endpoint: Option[Endpoint] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExperienceEndpoint = {
    import ExperienceEndpoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExperienceEndpoint
      .builder()
      .optionallyWith(endpointType.map(value => value.unwrap))(_.endpointType)
      .optionallyWith(
        endpoint.map(value => Endpoint.unwrap(value): java.lang.String)
      )(_.endpoint)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExperienceEndpoint.ReadOnly =
    zio.aws.kendra.model.ExperienceEndpoint.wrap(buildAwsValue())
}
object ExperienceEndpoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExperienceEndpoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExperienceEndpoint =
      zio.aws.kendra.model.ExperienceEndpoint(
        endpointType.map(value => value),
        endpoint.map(value => value)
      )
    def endpointType: Option[zio.aws.kendra.model.EndpointType]
    def endpoint: Option[Endpoint]
    def getEndpointType: ZIO[Any, AwsError, zio.aws.kendra.model.EndpointType] =
      AwsError.unwrapOptionField("endpointType", endpointType)
    def getEndpoint: ZIO[Any, AwsError, Endpoint] =
      AwsError.unwrapOptionField("endpoint", endpoint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExperienceEndpoint
  ) extends zio.aws.kendra.model.ExperienceEndpoint.ReadOnly {
    override val endpointType: Option[zio.aws.kendra.model.EndpointType] = scala
      .Option(impl.endpointType())
      .map(value => zio.aws.kendra.model.EndpointType.wrap(value))
    override val endpoint: Option[Endpoint] = scala
      .Option(impl.endpoint())
      .map(value => zio.aws.kendra.model.primitives.Endpoint(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExperienceEndpoint
  ): zio.aws.kendra.model.ExperienceEndpoint.ReadOnly = new Wrapper(impl)
}
