package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.EntityId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ExperienceEntitiesSummary(
    entityId: Option[EntityId] = None,
    entityType: Option[zio.aws.kendra.model.EntityType] = None,
    displayData: Option[zio.aws.kendra.model.EntityDisplayData] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummary = {
    import ExperienceEntitiesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummary
      .builder()
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(entityType.map(value => value.unwrap))(_.entityType)
      .optionallyWith(displayData.map(value => value.buildAwsValue()))(
        _.displayData
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly =
    zio.aws.kendra.model.ExperienceEntitiesSummary.wrap(buildAwsValue())
}
object ExperienceEntitiesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExperienceEntitiesSummary =
      zio.aws.kendra.model.ExperienceEntitiesSummary(
        entityId.map(value => value),
        entityType.map(value => value),
        displayData.map(value => value.asEditable)
      )
    def entityId: Option[EntityId]
    def entityType: Option[zio.aws.kendra.model.EntityType]
    def displayData: Option[zio.aws.kendra.model.EntityDisplayData.ReadOnly]
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getEntityType: ZIO[Any, AwsError, zio.aws.kendra.model.EntityType] =
      AwsError.unwrapOptionField("entityType", entityType)
    def getDisplayData
        : ZIO[Any, AwsError, zio.aws.kendra.model.EntityDisplayData.ReadOnly] =
      AwsError.unwrapOptionField("displayData", displayData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummary
  ) extends zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly {
    override val entityId: Option[EntityId] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.kendra.model.primitives.EntityId(value))
    override val entityType: Option[zio.aws.kendra.model.EntityType] = scala
      .Option(impl.entityType())
      .map(value => zio.aws.kendra.model.EntityType.wrap(value))
    override val displayData
        : Option[zio.aws.kendra.model.EntityDisplayData.ReadOnly] = scala
      .Option(impl.displayData())
      .map(value => zio.aws.kendra.model.EntityDisplayData.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExperienceEntitiesSummary
  ): zio.aws.kendra.model.ExperienceEntitiesSummary.ReadOnly = new Wrapper(impl)
}
