package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Timestamp, ExperienceId, ExperienceName}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ExperiencesSummary(
    name: Option[ExperienceName] = None,
    id: Option[ExperienceId] = None,
    createdAt: Option[Timestamp] = None,
    status: Option[zio.aws.kendra.model.ExperienceStatus] = None,
    endpoints: Option[Iterable[zio.aws.kendra.model.ExperienceEndpoint]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.ExperiencesSummary = {
    import ExperiencesSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.ExperiencesSummary
      .builder()
      .optionallyWith(
        name.map(value => ExperienceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        id.map(value => ExperienceId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        endpoints.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.endpoints)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.ExperiencesSummary.ReadOnly =
    zio.aws.kendra.model.ExperiencesSummary.wrap(buildAwsValue())
}
object ExperiencesSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.ExperiencesSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.ExperiencesSummary =
      zio.aws.kendra.model.ExperiencesSummary(
        name.map(value => value),
        id.map(value => value),
        createdAt.map(value => value),
        status.map(value => value),
        endpoints.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: Option[ExperienceName]
    def id: Option[ExperienceId]
    def createdAt: Option[Timestamp]
    def status: Option[zio.aws.kendra.model.ExperienceStatus]
    def endpoints
        : Option[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]]
    def getName: ZIO[Any, AwsError, ExperienceName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, ExperienceId] =
      AwsError.unwrapOptionField("id", id)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.ExperienceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getEndpoints: ZIO[Any, AwsError, List[
      zio.aws.kendra.model.ExperienceEndpoint.ReadOnly
    ]] = AwsError.unwrapOptionField("endpoints", endpoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.ExperiencesSummary
  ) extends zio.aws.kendra.model.ExperiencesSummary.ReadOnly {
    override val name: Option[ExperienceName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.ExperienceName(value))
    override val id: Option[ExperienceId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.ExperienceId(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val status: Option[zio.aws.kendra.model.ExperienceStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.ExperienceStatus.wrap(value))
    override val endpoints
        : Option[List[zio.aws.kendra.model.ExperienceEndpoint.ReadOnly]] = scala
      .Option(impl.endpoints())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.ExperienceEndpoint.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.ExperiencesSummary
  ): zio.aws.kendra.model.ExperiencesSummary.ReadOnly = new Wrapper(impl)
}
