package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.DocumentAttributeKey
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Facet(
    documentAttributeKey: Option[DocumentAttributeKey] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.kendra.model.Facet = {
    import Facet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.Facet
      .builder()
      .optionallyWith(
        documentAttributeKey.map(value =>
          DocumentAttributeKey.unwrap(value): java.lang.String
        )
      )(_.documentAttributeKey)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.Facet.ReadOnly =
    zio.aws.kendra.model.Facet.wrap(buildAwsValue())
}
object Facet {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.Facet] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.Facet =
      zio.aws.kendra.model.Facet(documentAttributeKey.map(value => value))
    def documentAttributeKey: Option[DocumentAttributeKey]
    def getDocumentAttributeKey: ZIO[Any, AwsError, DocumentAttributeKey] =
      AwsError.unwrapOptionField("documentAttributeKey", documentAttributeKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.Facet
  ) extends zio.aws.kendra.model.Facet.ReadOnly {
    override val documentAttributeKey: Option[DocumentAttributeKey] = scala
      .Option(impl.documentAttributeKey())
      .map(value => zio.aws.kendra.model.primitives.DocumentAttributeKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.Facet
  ): zio.aws.kendra.model.Facet.ReadOnly = new Wrapper(impl)
}
