package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{ErrorMessage, EntityId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class FailedEntity(
    entityId: Option[EntityId] = None,
    errorMessage: Option[ErrorMessage] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FailedEntity = {
    import FailedEntity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FailedEntity
      .builder()
      .optionallyWith(
        entityId.map(value => EntityId.unwrap(value): java.lang.String)
      )(_.entityId)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FailedEntity.ReadOnly =
    zio.aws.kendra.model.FailedEntity.wrap(buildAwsValue())
}
object FailedEntity {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.FailedEntity
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FailedEntity =
      zio.aws.kendra.model.FailedEntity(
        entityId.map(value => value),
        errorMessage.map(value => value)
      )
    def entityId: Option[EntityId]
    def errorMessage: Option[ErrorMessage]
    def getEntityId: ZIO[Any, AwsError, EntityId] =
      AwsError.unwrapOptionField("entityId", entityId)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FailedEntity
  ) extends zio.aws.kendra.model.FailedEntity.ReadOnly {
    override val entityId: Option[EntityId] = scala
      .Option(impl.entityId())
      .map(value => zio.aws.kendra.model.primitives.EntityId(value))
    override val errorMessage: Option[ErrorMessage] = scala
      .Option(impl.errorMessage())
      .map(value => zio.aws.kendra.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FailedEntity
  ): zio.aws.kendra.model.FailedEntity.ReadOnly = new Wrapper(impl)
}
