package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{LanguageCode, Timestamp, FaqName, FaqId}
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class FaqSummary(
    id: Option[FaqId] = None,
    name: Option[FaqName] = None,
    status: Option[zio.aws.kendra.model.FaqStatus] = None,
    createdAt: Option[Timestamp] = None,
    updatedAt: Option[Timestamp] = None,
    fileFormat: Option[zio.aws.kendra.model.FaqFileFormat] = None,
    languageCode: Option[LanguageCode] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.FaqSummary = {
    import FaqSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.FaqSummary
      .builder()
      .optionallyWith(id.map(value => FaqId.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => FaqName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(updatedAt.map(value => Timestamp.unwrap(value): Instant))(
        _.updatedAt
      )
      .optionallyWith(fileFormat.map(value => value.unwrap))(_.fileFormat)
      .optionallyWith(
        languageCode.map(value => LanguageCode.unwrap(value): java.lang.String)
      )(_.languageCode)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.FaqSummary.ReadOnly =
    zio.aws.kendra.model.FaqSummary.wrap(buildAwsValue())
}
object FaqSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.kendra.model.FaqSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.FaqSummary =
      zio.aws.kendra.model.FaqSummary(
        id.map(value => value),
        name.map(value => value),
        status.map(value => value),
        createdAt.map(value => value),
        updatedAt.map(value => value),
        fileFormat.map(value => value),
        languageCode.map(value => value)
      )
    def id: Option[FaqId]
    def name: Option[FaqName]
    def status: Option[zio.aws.kendra.model.FaqStatus]
    def createdAt: Option[Timestamp]
    def updatedAt: Option[Timestamp]
    def fileFormat: Option[zio.aws.kendra.model.FaqFileFormat]
    def languageCode: Option[LanguageCode]
    def getId: ZIO[Any, AwsError, FaqId] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, FaqName] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, AwsError, zio.aws.kendra.model.FaqStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("updatedAt", updatedAt)
    def getFileFormat: ZIO[Any, AwsError, zio.aws.kendra.model.FaqFileFormat] =
      AwsError.unwrapOptionField("fileFormat", fileFormat)
    def getLanguageCode: ZIO[Any, AwsError, LanguageCode] =
      AwsError.unwrapOptionField("languageCode", languageCode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.FaqSummary
  ) extends zio.aws.kendra.model.FaqSummary.ReadOnly {
    override val id: Option[FaqId] = scala
      .Option(impl.id())
      .map(value => zio.aws.kendra.model.primitives.FaqId(value))
    override val name: Option[FaqName] = scala
      .Option(impl.name())
      .map(value => zio.aws.kendra.model.primitives.FaqName(value))
    override val status: Option[zio.aws.kendra.model.FaqStatus] = scala
      .Option(impl.status())
      .map(value => zio.aws.kendra.model.FaqStatus.wrap(value))
    override val createdAt: Option[Timestamp] = scala
      .Option(impl.createdAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val updatedAt: Option[Timestamp] = scala
      .Option(impl.updatedAt())
      .map(value => zio.aws.kendra.model.primitives.Timestamp(value))
    override val fileFormat: Option[zio.aws.kendra.model.FaqFileFormat] = scala
      .Option(impl.fileFormat())
      .map(value => zio.aws.kendra.model.FaqFileFormat.wrap(value))
    override val languageCode: Option[LanguageCode] = scala
      .Option(impl.languageCode())
      .map(value => zio.aws.kendra.model.primitives.LanguageCode(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.FaqSummary
  ): zio.aws.kendra.model.FaqSummary.ReadOnly = new Wrapper(impl)
}
