package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Integer, SuggestionQueryText, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetQuerySuggestionsRequest(
    indexId: IndexId,
    queryText: SuggestionQueryText,
    maxSuggestionsCount: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest = {
    import GetQuerySuggestionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .queryText(SuggestionQueryText.unwrap(queryText): java.lang.String)
      .optionallyWith(
        maxSuggestionsCount.map(value => value: java.lang.Integer)
      )(_.maxSuggestionsCount)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetQuerySuggestionsRequest.ReadOnly =
    zio.aws.kendra.model.GetQuerySuggestionsRequest.wrap(buildAwsValue())
}
object GetQuerySuggestionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetQuerySuggestionsRequest =
      zio.aws.kendra.model.GetQuerySuggestionsRequest(
        indexId,
        queryText,
        maxSuggestionsCount.map(value => value)
      )
    def indexId: IndexId
    def queryText: SuggestionQueryText
    def maxSuggestionsCount: Option[Integer]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getQueryText: ZIO[Any, Nothing, SuggestionQueryText] =
      ZIO.succeed(queryText)
    def getMaxSuggestionsCount: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxSuggestionsCount", maxSuggestionsCount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
  ) extends zio.aws.kendra.model.GetQuerySuggestionsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val queryText: SuggestionQueryText =
      zio.aws.kendra.model.primitives.SuggestionQueryText(impl.queryText())
    override val maxSuggestionsCount: Option[Integer] =
      scala.Option(impl.maxSuggestionsCount()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsRequest
  ): zio.aws.kendra.model.GetQuerySuggestionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
