package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.QuerySuggestionsId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetQuerySuggestionsResponse(
    querySuggestionsId: Option[QuerySuggestionsId] = None,
    suggestions: Option[Iterable[zio.aws.kendra.model.Suggestion]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse = {
    import GetQuerySuggestionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
      .builder()
      .optionallyWith(
        querySuggestionsId.map(value =>
          QuerySuggestionsId.unwrap(value): java.lang.String
        )
      )(_.querySuggestionsId)
      .optionallyWith(
        suggestions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.suggestions)
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly =
    zio.aws.kendra.model.GetQuerySuggestionsResponse.wrap(buildAwsValue())
}
object GetQuerySuggestionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetQuerySuggestionsResponse =
      zio.aws.kendra.model.GetQuerySuggestionsResponse(
        querySuggestionsId.map(value => value),
        suggestions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def querySuggestionsId: Option[QuerySuggestionsId]
    def suggestions: Option[List[zio.aws.kendra.model.Suggestion.ReadOnly]]
    def getQuerySuggestionsId: ZIO[Any, AwsError, QuerySuggestionsId] =
      AwsError.unwrapOptionField("querySuggestionsId", querySuggestionsId)
    def getSuggestions
        : ZIO[Any, AwsError, List[zio.aws.kendra.model.Suggestion.ReadOnly]] =
      AwsError.unwrapOptionField("suggestions", suggestions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
  ) extends zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly {
    override val querySuggestionsId: Option[QuerySuggestionsId] = scala
      .Option(impl.querySuggestionsId())
      .map(value => zio.aws.kendra.model.primitives.QuerySuggestionsId(value))
    override val suggestions
        : Option[List[zio.aws.kendra.model.Suggestion.ReadOnly]] = scala
      .Option(impl.suggestions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.kendra.model.Suggestion.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetQuerySuggestionsResponse
  ): zio.aws.kendra.model.GetQuerySuggestionsResponse.ReadOnly = new Wrapper(
    impl
  )
}
