package zio.aws.kendra.model
import zio.ZIO
import zio.aws.kendra.model.primitives.{Integer, NextToken, IndexId}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class GetSnapshotsRequest(
    indexId: IndexId,
    interval: zio.aws.kendra.model.Interval,
    metricType: zio.aws.kendra.model.MetricType,
    nextToken: Option[NextToken] = None,
    maxResults: Option[Integer] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest = {
    import GetSnapshotsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest
      .builder()
      .indexId(IndexId.unwrap(indexId): java.lang.String)
      .interval(interval.unwrap)
      .metricType(metricType.unwrap)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .build()
  }
  def asReadOnly: zio.aws.kendra.model.GetSnapshotsRequest.ReadOnly =
    zio.aws.kendra.model.GetSnapshotsRequest.wrap(buildAwsValue())
}
object GetSnapshotsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.kendra.model.GetSnapshotsRequest =
      zio.aws.kendra.model.GetSnapshotsRequest(
        indexId,
        interval,
        metricType,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def indexId: IndexId
    def interval: zio.aws.kendra.model.Interval
    def metricType: zio.aws.kendra.model.MetricType
    def nextToken: Option[NextToken]
    def maxResults: Option[Integer]
    def getIndexId: ZIO[Any, Nothing, IndexId] = ZIO.succeed(indexId)
    def getInterval: ZIO[Any, Nothing, zio.aws.kendra.model.Interval] =
      ZIO.succeed(interval)
    def getMetricType: ZIO[Any, Nothing, zio.aws.kendra.model.MetricType] =
      ZIO.succeed(metricType)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest
  ) extends zio.aws.kendra.model.GetSnapshotsRequest.ReadOnly {
    override val indexId: IndexId =
      zio.aws.kendra.model.primitives.IndexId(impl.indexId())
    override val interval: zio.aws.kendra.model.Interval =
      zio.aws.kendra.model.Interval.wrap(impl.interval())
    override val metricType: zio.aws.kendra.model.MetricType =
      zio.aws.kendra.model.MetricType.wrap(impl.metricType())
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.kendra.model.primitives.NextToken(value))
    override val maxResults: Option[Integer] =
      scala.Option(impl.maxResults()).map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.kendra.model.GetSnapshotsRequest
  ): zio.aws.kendra.model.GetSnapshotsRequest.ReadOnly = new Wrapper(impl)
}
